/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import org.opendatafoundation.data.FileFormatInfo;
import org.opendatafoundation.data.Utils;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;
import org.opendatafoundation.data.spss.SPSSUtils;
import org.opendatafoundation.data.spss.SPSSVariable;
import org.opendatafoundation.data.spss.SPSSVariableCategory;

public class SPSSNumericVariable
extends SPSSVariable {
    public List<Double> data;
    public double value;
    public double min = Double.MAX_VALUE;
    public double max = Double.MIN_VALUE;
    public double mean = 0.0;
    public double min_wgt = Double.MAX_VALUE;
    public double max_wgt = Double.MIN_VALUE;
    public double mean_wgt = 0.0;

    public SPSSNumericVariable(SPSSFile sPSSFile) {
        super(sPSSFile);
        this.data = new ArrayList<Double>();
        this.type = SPSSVariable.VariableType.NUMERIC;
    }

    @Override
    public SPSSVariableCategory addCategory(byte[] byArray, String string) throws SPSSFileException {
        double d = SPSSUtils.byte8ToDouble(byArray);
        return this.addCategory(d, string);
    }

    public SPSSVariableCategory addCategory(double d, String string) throws SPSSFileException {
        String string2 = this.valueToString(d).trim();
        SPSSVariableCategory sPSSVariableCategory = (SPSSVariableCategory)this.categoryMap.get(string2);
        if (sPSSVariableCategory == null) {
            sPSSVariableCategory = new SPSSVariableCategory();
            this.categoryMap.put(string2, sPSSVariableCategory);
        }
        sPSSVariableCategory.value = d;
        sPSSVariableCategory.strValue = string2;
        sPSSVariableCategory.label = string;
        return sPSSVariableCategory;
    }

    @Override
    public SPSSVariableCategory getCategory(byte[] byArray) throws SPSSFileException {
        double d = SPSSUtils.byte8ToDouble(byArray);
        return this.getCategory(d);
    }

    public SPSSVariableCategory getCategory(double d) throws SPSSFileException {
        return (SPSSVariableCategory)this.categoryMap.get(this.valueToString(d).trim());
    }

    @Override
    public String getSPSSFormat() {
        String string = "";
        switch (this.variableRecord.writeFormatType) {
            case 3: {
                string = "Comma" + this.getLength() + "." + this.getDecimals();
                break;
            }
            case 4: {
                string = "Dollar" + this.getLength() + "." + this.getDecimals();
                break;
            }
            case 5: {
                string = "F" + this.getLength() + "." + this.getDecimals();
                break;
            }
            case 17: {
                string = "E" + this.getLength() + "." + this.getDecimals();
                break;
            }
            case 20: {
                string = "Date" + this.getLength();
                break;
            }
            case 21: {
                string = "Time" + this.getLength() + "." + this.getDecimals();
                break;
            }
            case 22: {
                string = "DateTime" + this.getLength() + "." + this.getDecimals();
                break;
            }
            case 23: {
                string = "ADate" + this.getLength();
                break;
            }
            case 24: {
                string = "JDate" + this.getLength();
                break;
            }
            case 25: {
                string = "DTime" + this.getLength() + "." + this.getDecimals();
                break;
            }
            case 26: {
                string = "Wkday" + this.getLength();
                break;
            }
            case 27: {
                string = "Month" + this.getLength();
                break;
            }
            case 28: {
                string = "Moyr" + this.getLength();
                break;
            }
            case 29: {
                string = "QYr" + this.getLength();
                break;
            }
            case 30: {
                string = "Wkyr" + this.getLength();
                break;
            }
            case 32: {
                string = "Dot" + this.getLength() + "." + this.getDecimals();
                break;
            }
            case 33: {
                string = "Cca" + this.getLength() + "." + this.getDecimals();
                break;
            }
            case 34: {
                string = "Ccb" + this.getLength() + "." + this.getDecimals();
                break;
            }
            case 35: {
                string = "Ccc" + this.getLength() + "." + this.getDecimals();
                break;
            }
            case 36: {
                string = "Ccd" + this.getLength() + "." + this.getDecimals();
                break;
            }
            case 37: {
                string = "Cce" + this.getLength() + "." + this.getDecimals();
                break;
            }
            case 38: {
                string = "EDate" + this.getLength();
                break;
            }
            case 39: {
                string = "SDate" + this.getLength();
                break;
            }
            default: {
                string = "other";
            }
        }
        return string;
    }

    @Override
    public String getValueAsString(int n, FileFormatInfo fileFormatInfo) throws SPSSFileException {
        double d;
        if (n < 0 || n > this.data.size()) {
            throw new SPSSFileException("Invalid observation number [" + n + ". Range is 1 to " + this.data.size() + "] or 0.");
        }
        if (n == 0) {
            d = this.value;
        } else {
            if (n > 0 && this.data.size() == 0) {
                throw new SPSSFileException("No data availble");
            }
            d = this.data.get(n - 1);
        }
        String string = this.valueToString(d);
        if (fileFormatInfo.asciiFormat == FileFormatInfo.ASCIIFormat.FIXED) {
            if (string.equals(".")) {
                string = Utils.leftPad("", this.getLength());
            } else if (string.length() < this.getLength()) {
                string = Utils.leftPad(string, this.getLength());
            } else if (string.length() > this.getLength()) {
                int n2;
                string = this.variableRecord.writeFormatType == 5 && this.getDecimals() > 0 ? ((n2 = string.lastIndexOf(".")) + 2 <= this.getLength() ? String.format(Locale.US, "%" + this.getLength() + "." + (this.getLength() - n2 - 1) + "f", this.value) : (n2 <= this.getLength() ? Utils.leftPad(string.substring(1, n2 - 1), this.getLength()) : Utils.leftPad("", this.getLength(), '*'))) : Utils.leftPad("", this.getLength(), '*');
            }
        } else {
            string = string.trim();
        }
        if (fileFormatInfo.format == FileFormatInfo.Format.ASCII && fileFormatInfo.asciiFormat == FileFormatInfo.ASCIIFormat.CSV && (string.contains(",") || string.contains("\"") || string.contains("\n"))) {
            string = "\"" + string + "\"";
        }
        return string;
    }

    public String valueToString(double d) throws SPSSFileException {
        String string;
        String string2 = "";
        if (new Double(d).isNaN()) {
            string = ".";
        } else {
            switch (this.variableRecord.writeFormatType) {
                case 3: {
                    string2 = string2 + "%,." + this.getDecimals() + "f";
                    string = String.format(Locale.US, string2, d);
                    break;
                }
                case 4: {
                    string2 = string2 + "$%." + this.getDecimals() + "f";
                    string = String.format(Locale.US, string2, d);
                    break;
                }
                case 5: {
                    string2 = string2 + "%" + this.getLength() + "." + this.getDecimals() + "f";
                    string = String.format(Locale.US, string2, d);
                    break;
                }
                case 17: {
                    int n = this.getDecimals();
                    if (n > 0) {
                        --n;
                    }
                    string2 = string2 + "% " + this.getLength() + "." + n + "E";
                    string = String.format(Locale.US, string2, d);
                    break;
                }
                case 20: {
                    GregorianCalendar gregorianCalendar = SPSSUtils.numericToCalendar(d);
                    string2 = this.getLength() == 11 ? string2 + "%1$td-%1$tb-%1$tY" : string2 + "%1$td-%1$tb-%1$ty";
                    string = String.format(Locale.US, string2, gregorianCalendar).toUpperCase();
                    break;
                }
                case 21: {
                    GregorianCalendar gregorianCalendar = SPSSUtils.numericToCalendar(d);
                    string2 = string2 + "%1$tH:%1$tM";
                    if (this.getLength() >= 8) {
                        string2 = string2 + ":%1$tS";
                    }
                    if (this.getLength() == 11) {
                        string2 = string2 + ".%2$2d";
                    }
                    string = String.format(Locale.US, string2, gregorianCalendar, gregorianCalendar.get(14) / 10).toUpperCase();
                    break;
                }
                case 22: {
                    GregorianCalendar gregorianCalendar = SPSSUtils.numericToCalendar(d);
                    string2 = string2 + "%1$td-%1$tb-%1$tY %1$tH:%1$tM";
                    if (this.getLength() >= 20) {
                        string2 = string2 + ":%1$tS";
                    }
                    if (this.getLength() == 23) {
                        string2 = string2 + ".%2$2d";
                    }
                    string = String.format(Locale.US, string2, gregorianCalendar, gregorianCalendar.get(14) / 10).toUpperCase();
                    break;
                }
                case 23: {
                    GregorianCalendar gregorianCalendar = SPSSUtils.numericToCalendar(d);
                    string2 = this.getLength() == 10 ? string2 + "%1$tm/%1$td/%1$tY" : string2 + "%1$tm/%1$td/%1$ty";
                    string = String.format(Locale.US, string2, gregorianCalendar);
                    break;
                }
                case 24: {
                    GregorianCalendar gregorianCalendar = SPSSUtils.numericToCalendar(d);
                    string2 = this.getLength() == 7 ? string2 + "%1$tY%1$tj" : string2 + "%1$ty%1$tj";
                    string = String.format(Locale.US, string2, gregorianCalendar);
                    break;
                }
                case 25: {
                    GregorianCalendar gregorianCalendar = SPSSUtils.numericToCalendar(d);
                    string2 = string2 + "%1$tj:%1$tH:%1$tM";
                    if (this.getLength() >= 12) {
                        string2 = string2 + ":%1$tS";
                    }
                    if (this.getLength() == 15) {
                        string2 = string2 + ".%2$2d";
                    }
                    string = String.format(Locale.US, string2, gregorianCalendar, gregorianCalendar.get(14) / 10);
                    break;
                }
                case 26: {
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.set(7, (int)d);
                    string2 = this.getLength() == 9 ? string2 + "%1$tA" : string2 + "%1$ta";
                    string = String.format(Locale.US, string2, gregorianCalendar).toUpperCase();
                    break;
                }
                case 27: {
                    GregorianCalendar gregorianCalendar = new GregorianCalendar();
                    gregorianCalendar.set(2, (int)d - 1);
                    string2 = string2 + "%1$tb";
                    string = String.format(Locale.US, string2, gregorianCalendar).toUpperCase();
                    break;
                }
                case 28: {
                    GregorianCalendar gregorianCalendar = SPSSUtils.numericToCalendar(d);
                    string2 = this.getLength() == 8 ? string2 + "%1$tb %1$tY" : string2 + "%1$tb %1$ty";
                    string = String.format(Locale.US, string2, gregorianCalendar).toUpperCase();
                    break;
                }
                case 29: {
                    GregorianCalendar gregorianCalendar = SPSSUtils.numericToCalendar(d);
                    string2 = gregorianCalendar.get(2) <= 3 ? string2 + "1 Q " : (gregorianCalendar.get(2) <= 6 ? string2 + "2 Q " : (gregorianCalendar.get(2) <= 9 ? string2 + "3 Q " : string2 + "4 Q"));
                    string2 = this.getLength() == 8 ? string2 + "%1$tY" : string2 + "%1$ty";
                    string = String.format(Locale.US, string2, gregorianCalendar);
                    break;
                }
                case 30: {
                    GregorianCalendar gregorianCalendar = SPSSUtils.numericToCalendar(d);
                    string2 = this.getLength() == 10 ? string2 + "%1$2d WK %2$tY" : string2 + "%1$2d WK %2$ty";
                    string = String.format(Locale.US, string2, gregorianCalendar.get(3), gregorianCalendar);
                    break;
                }
                case 32: {
                    string2 = string2 + "%,." + this.getDecimals() + "f";
                    string = String.format(Locale.GERMANY, string2, d);
                    break;
                }
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: {
                    string2 = string2 + "%" + this.getLength() + "." + this.getDecimals() + "f";
                    string = String.format(Locale.US, string2, d);
                    break;
                }
                case 38: {
                    GregorianCalendar gregorianCalendar = SPSSUtils.numericToCalendar(d);
                    string2 = this.getLength() == 10 ? string2 + "%1$td.%1$tm.%1$tY" : string2 + "%1$td.%1$tm.%1$ty";
                    string = String.format(Locale.US, string2, gregorianCalendar);
                    break;
                }
                case 39: {
                    GregorianCalendar gregorianCalendar = SPSSUtils.numericToCalendar(d);
                    string2 = this.getLength() == 10 ? string2 + "%1$tY/%1$tm.%1$td" : string2 + "%1$ty/%1$tm/%1$td";
                    string = String.format(Locale.US, string2, gregorianCalendar);
                    break;
                }
                default: {
                    throw new SPSSFileException("Unknown write format type [" + this.variableRecord.writeFormatType + "]");
                }
            }
        }
        return string;
    }
}

