/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.io.IOException;
import org.opendatafoundation.data.spss.SPSSAbstractRecordType;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;

public class SPSSRecordType1
extends SPSSAbstractRecordType {
    String recordTypeCode;
    String productIdentification;
    int layoutCode;
    int OBSperObservation;
    int compressionSwitch;
    int weightVariableIndex;
    int numberOfCases;
    double compressionBias;
    String creationDate;
    String creationTime;
    String fileLabel;

    @Override
    public void read(SPSSFile sPSSFile) throws IOException, SPSSFileException {
        this.fileLocation = sPSSFile.getFilePointer();
        this.recordTypeCode = sPSSFile.readSPSSString(4);
        if (this.recordTypeCode.compareTo("$FL2") != 0) {
            throw new SPSSFileException("Read header error: this is not a valid SPSS file. Does not start with $FL2.");
        }
        this.productIdentification = sPSSFile.readSPSSString(60).replaceAll("\\s+$", "");
        long l = sPSSFile.getFilePointer();
        this.layoutCode = sPSSFile.readSPSSInt();
        if (this.layoutCode != 2 && this.layoutCode != 3) {
            sPSSFile.isBigEndian = true;
            sPSSFile.seek(l);
            this.layoutCode = sPSSFile.readSPSSInt();
        }
        this.OBSperObservation = sPSSFile.readSPSSInt();
        this.compressionSwitch = sPSSFile.readSPSSInt();
        this.weightVariableIndex = sPSSFile.readSPSSInt();
        this.numberOfCases = sPSSFile.readSPSSInt();
        this.compressionBias = sPSSFile.readSPSSDouble();
        this.creationDate = sPSSFile.readSPSSString(9);
        this.creationTime = sPSSFile.readSPSSString(8);
        this.fileLabel = sPSSFile.readSPSSString(64).replaceAll("\\s+$", "");
        sPSSFile.skipBytes(3);
    }

    @Override
    public String toString() {
        String string = "";
        string = string + "\nRECORD TYPE 1 - GENERAL INFO";
        string = string + "\nLocation        : " + this.fileLocation;
        string = string + "\nRecord Type     : " + this.recordTypeCode;
        string = string + "\nProduct ID      : " + this.productIdentification;
        string = string + "\nLayout code     : " + this.layoutCode;
        string = string + "\nOBS per obs     : " + this.OBSperObservation;
        string = string + "\nCompression     : " + this.compressionSwitch;
        string = string + "\nWeight Variable : " + this.weightVariableIndex;
        string = string + "\nNumber of cases : " + this.numberOfCases;
        string = string + "\nCompression bias: " + this.compressionBias;
        string = string + "\nCreation date   : " + this.creationDate;
        string = string + "\nCreation time   : " + this.creationTime;
        string = string + "\nFile label      : " + this.fileLabel;
        return string;
    }
}

