/*
 * Decompiled with CFR 0.152.
 */
package org.opendatafoundation.data.spss;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.opendatafoundation.data.FileFormatInfo;
import org.opendatafoundation.data.Utils;
import org.opendatafoundation.data.spss.SPSSFile;
import org.opendatafoundation.data.spss.SPSSFileException;
import org.opendatafoundation.data.spss.SPSSRecordType2;
import org.opendatafoundation.data.spss.SPSSRecordType3;
import org.opendatafoundation.data.spss.SPSSUtils;
import org.opendatafoundation.data.spss.SPSSVariableCategory;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class SPSSVariable {
    SPSSFile file;
    public SPSSRecordType2 variableRecord;
    public SPSSRecordType3 valueLabelRecord;
    VariableType type;
    int variableNumber = 0;
    String variableName = "";
    String variableShortName = "";
    int measure = -1;
    int displayWidth = -1;
    int alignment = -1;
    public Map<String, SPSSVariableCategory> categoryMap = new LinkedHashMap<String, SPSSVariableCategory>();

    public SPSSVariable(SPSSFile sPSSFile) {
        this.file = sPSSFile;
    }

    public abstract SPSSVariableCategory addCategory(byte[] var1, String var2) throws SPSSFileException;

    public String getAlignmentLabel() {
        String string = "";
        switch (this.alignment) {
            case 0: {
                string = "Left";
                break;
            }
            case 1: {
                string = "Center";
                break;
            }
            case 2: {
                string = "Right";
            }
        }
        return string;
    }

    public abstract SPSSVariableCategory getCategory(byte[] var1) throws SPSSFileException;

    public Element getDDI2(Document document, int n) throws SPSSFileException {
        return this.getDDI2(document, new FileFormatInfo(), n);
    }

    public Element getDDI2(Document document, FileFormatInfo fileFormatInfo, int n) throws SPSSFileException {
        Element element = document.createElementNS("http://www.icpsr.umich.edu/DDI", "var");
        if (this.getDecimals() > 0) {
            element.setAttribute("dcml", "" + this.getDecimals());
        }
        if (this.type == VariableType.NUMERIC) {
            switch (this.measure) {
                case 1: 
                case 2: {
                    element.setAttribute("intrvl", "discrete");
                    break;
                }
                case 3: {
                    element.setAttribute("intrvl", "contin");
                }
            }
        }
        Element element2 = (Element)element.appendChild(document.createElementNS("http://www.icpsr.umich.edu/DDI", "location"));
        element2.setAttribute("width", "" + this.getLength(fileFormatInfo));
        element2.setAttribute("StartPos", "" + n);
        element2.setAttribute("EndPos", "" + (n + this.getLength(fileFormatInfo)));
        element.setAttribute("name", this.getName());
        element2 = (Element)element.appendChild(document.createElementNS("http://www.icpsr.umich.edu/DDI", "labl"));
        element2.setTextContent(this.getLabel());
        if (!this.categoryMap.isEmpty()) {
            for (String string : this.categoryMap.keySet()) {
                SPSSVariableCategory sPSSVariableCategory = this.categoryMap.get(string);
                Element element3 = (Element)element.appendChild(document.createElementNS("http://www.icpsr.umich.edu/DDI", "catgry"));
                if (sPSSVariableCategory.isMissing) {
                    element3.setAttribute("missing", "Y");
                }
                element2 = (Element)element3.appendChild(document.createElementNS("http://www.icpsr.umich.edu/DDI", "catValu"));
                element2.setTextContent(sPSSVariableCategory.strValue);
                element2 = (Element)element3.appendChild(document.createElementNS("http://www.icpsr.umich.edu/DDI", "labl"));
                element2.setTextContent(sPSSVariableCategory.label);
            }
        }
        element2 = (Element)element.appendChild(document.createElementNS("http://www.icpsr.umich.edu/DDI", "varFormat"));
        if (this.type == VariableType.NUMERIC) {
            element2.setAttribute("type", "numeric");
        } else {
            element2.setAttribute("type", "character");
        }
        element2.setAttribute("schema", "SPSS");
        element2.setAttribute("formatname", this.getSPSSFormat());
        return element;
    }

    public String getDDI3DefaultCategorySchemeID() {
        return this.file.getUniqueID() + "_" + this.file.categorySchemeIDSuffix + "_V" + this.variableNumber;
    }

    public String getDDI3DefaultCodeSchemeID() {
        return this.file.getUniqueID() + "_" + this.file.codeSchemeIDSuffix + "_V" + this.variableNumber;
    }

    public Element getDDI3CategoryScheme(Document document) {
        return this.getDDI3CategoryScheme(document, null);
    }

    private Element getDDI3CategoryScheme(Document document, String string) {
        Element element = null;
        if (!this.categoryMap.isEmpty()) {
            element = document.createElementNS("ddi:logicalproduct:3_0", "CategoryScheme");
            if (string == null) {
                string = this.getDDI3DefaultCategorySchemeID();
            }
            Utils.setDDIMaintainableId(element, string);
            int n = 0;
            Iterator<String> iterator = this.categoryMap.keySet().iterator();
            boolean bl = false;
            while (iterator.hasNext()) {
                Element element2;
                String string2 = iterator.next();
                SPSSVariableCategory sPSSVariableCategory = this.categoryMap.get(string2);
                if (sPSSVariableCategory.isMissing && sPSSVariableCategory.label == "") {
                    if (bl) continue;
                    element2 = (Element)element.appendChild(document.createElementNS("ddi:logicalproduct:3_0", "Category"));
                    Utils.setDDIVersionableId(element2, "MISSING");
                    element2.setAttribute("missing", "true");
                    bl = true;
                    continue;
                }
                element2 = (Element)element.appendChild(document.createElementNS("ddi:logicalproduct:3_0", "Category"));
                Utils.setDDIVersionableId(element2, this.file.variableCategoryPrefix + "_" + ++n);
                if (sPSSVariableCategory.isMissing) {
                    element2.setAttribute("missing", "true");
                }
                Element element3 = (Element)element2.appendChild(document.createElementNS("ddi:reusable:3_0", "Label"));
                element3.setTextContent(sPSSVariableCategory.label);
            }
        }
        return element;
    }

    public Element getDDI3CodeScheme(Document document) throws DOMException, SPSSFileException {
        return this.getDDI3CodeScheme(document, null, null);
    }

    private Element getDDI3CodeScheme(Document document, String string, String string2) throws DOMException, SPSSFileException {
        Element element = null;
        if (!this.categoryMap.isEmpty()) {
            element = document.createElementNS("ddi:logicalproduct:3_0", "CodeScheme");
            if (string == null) {
                string = this.getDDI3DefaultCategorySchemeID();
            }
            if (string2 == null) {
                string2 = this.getDDI3DefaultCodeSchemeID();
            }
            Utils.setDDIMaintainableId(element, string2);
            Element element2 = (Element)element.appendChild(document.createElementNS("ddi:logicalproduct:3_0", "CategorySchemeReference"));
            Element element3 = (Element)element2.appendChild(document.createElementNS("ddi:reusable:3_0", "ID"));
            element3.setTextContent(string);
            Iterator<String> iterator = this.categoryMap.keySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                String string3 = iterator.next();
                SPSSVariableCategory sPSSVariableCategory = this.categoryMap.get(string3);
                Element element4 = (Element)element.appendChild(document.createElementNS("ddi:logicalproduct:3_0", "Code"));
                Element element5 = (Element)element4.appendChild(document.createElementNS("ddi:logicalproduct:3_0", "CategoryReference"));
                element3 = (Element)element5.appendChild(document.createElementNS("ddi:reusable:3_0", "ID"));
                if (sPSSVariableCategory.isMissing && sPSSVariableCategory.label == "") {
                    element3.setTextContent("MISSING");
                } else {
                    element3.setTextContent(this.file.variableCategoryPrefix + "_" + ++n);
                }
                element3 = (Element)element4.appendChild(document.createElementNS("ddi:logicalproduct:3_0", "Value"));
                element3.setTextContent(sPSSVariableCategory.strValue);
            }
        }
        return element;
    }

    public Element getDDI3DataItem(Document document, FileFormatInfo fileFormatInfo, int n) throws DOMException, SPSSFileException {
        Element element = document.createElementNS("ddi:physicaldataproduct:3_0", "DataItem");
        Element element2 = (Element)element.appendChild(document.createElementNS("ddi:physicaldataproduct:3_0", "VariableReference"));
        Element element3 = (Element)element2.appendChild(document.createElementNS("ddi:reusable:3_0", "ID"));
        element3.setTextContent(this.file.variableIDPrefix + this.variableNumber);
        Element element4 = (Element)element.appendChild(document.createElementNS("ddi:physicaldataproduct:3_0", "PhysicalLocation"));
        element3 = (Element)element4.appendChild(document.createElementNS("ddi:physicaldataproduct:3_0", "StorageFormat"));
        element3.setTextContent(this.getSPSSFormat());
        element3 = (Element)element4.appendChild(document.createElementNS("ddi:physicaldataproduct:3_0", "StartPosition"));
        element3.setTextContent("" + n);
        element3 = (Element)element4.appendChild(document.createElementNS("ddi:physicaldataproduct:3_0", "Width"));
        element3.setTextContent("" + this.getLength(fileFormatInfo));
        if (this.getDecimals() > 0) {
            element3 = (Element)element4.appendChild(document.createElementNS("ddi:physicaldataproduct:3_0", "DecimalPositions"));
            element3.setTextContent("" + this.getDecimals());
        }
        return element;
    }

    public Element getDDI3ProprietaryDataItem(Document document) throws DOMException, SPSSFileException {
        Element element = document.createElementNS("ddi:physicaldataproduct/proprietary:3_0_Beta", "DataItem");
        Element element2 = (Element)element.appendChild(document.createElementNS("ddi:physicaldataproduct/proprietary:3_0_Beta", "VariableReference"));
        Element element3 = (Element)element2.appendChild(document.createElementNS("ddi:reusable:3_0", "ID"));
        element3.setTextContent(this.file.variableIDPrefix + this.variableNumber);
        element3 = (Element)element.appendChild(document.createElementNS("ddi:physicaldataproduct/proprietary:3_0_Beta", "ProprietaryDataType"));
        element3.setTextContent(this.variableRecord.variableTypeCode == 0 ? "numeric" : "string");
        element3 = (Element)element.appendChild(document.createElementNS("ddi:physicaldataproduct/proprietary:3_0_Beta", "ProprietaryOutputFormat"));
        element3.setTextContent(this.getSPSSFormat());
        Element element4 = (Element)element.appendChild(document.createElementNS("ddi:reusable:3_0", "ProprietaryInfo"));
        element3 = (Element)element4.appendChild(document.createElementNS("ddi:reusable:3_0", "ProprietaryProperty"));
        element3.setAttribute("name", "Width");
        element3.setTextContent("" + this.variableRecord.writeFormatWidth);
        element3 = (Element)element4.appendChild(document.createElementNS("ddi:reusable:3_0", "ProprietaryProperty"));
        element3.setAttribute("name", "Decimals");
        element3.setTextContent("" + this.getDecimals());
        if (this.variableRecord.missingValueFormatCode != 0) {
            element3 = (Element)element4.appendChild(document.createElementNS("ddi:reusable:3_0", "ProprietaryProperty"));
            element3.setAttribute("name", "MissingFormatCode");
            element3.setTextContent("" + this.variableRecord.missingValueFormatCode);
            for (int i = 0; i < Math.abs(this.variableRecord.missingValueFormatCode); ++i) {
                element3 = (Element)element4.appendChild(document.createElementNS("ddi:reusable:3_0", "ProprietaryProperty"));
                element3.setAttribute("name", "MissingValue" + i);
                if (this.variableRecord.variableTypeCode == 0) {
                    element3.setTextContent("" + SPSSUtils.byte8ToDouble(this.variableRecord.missingValue[i]));
                    continue;
                }
                String string = this.file.charset == null ? SPSSUtils.byte8ToString(this.variableRecord.missingValue[i]) : SPSSUtils.byte8ToString(this.variableRecord.missingValue[i], this.file.charset);
                element3.setTextContent(string);
            }
        }
        if (this.displayWidth != -1) {
            element3 = (Element)element4.appendChild(document.createElementNS("ddi:reusable:3_0", "ProprietaryProperty"));
            element3.setAttribute("name", "DisplayWidth");
            element3.setTextContent("" + this.displayWidth);
        }
        if (this.alignment != -1) {
            element3 = (Element)element4.appendChild(document.createElementNS("ddi:reusable:3_0", "ProprietaryProperty"));
            element3.setAttribute("name", "Alignment");
            element3.setTextContent("" + this.getAlignmentLabel());
        }
        if (this.measure != -1) {
            element3 = (Element)element4.appendChild(document.createElementNS("ddi:reusable:3_0", "ProprietaryProperty"));
            element3.setAttribute("name", "Measure");
            element3.setTextContent("" + this.getMeasureLabel());
        }
        return element;
    }

    public Element getDDI3Variable(Document document) {
        return this.getDDI3Variable(document, null);
    }

    private Element getDDI3Variable(Document document, String string) {
        Element element = null;
        element = document.createElementNS("ddi:logicalproduct:3_0", "Variable");
        Utils.setDDIVersionableId(element, this.file.variableIDPrefix + this.variableNumber);
        Element element2 = (Element)element.appendChild(document.createElementNS("ddi:reusable:3_0", "Name"));
        element2.setTextContent(this.getName());
        element2 = (Element)element.appendChild(document.createElementNS("ddi:reusable:3_0", "Label"));
        element2.setAttribute("type", "label");
        element2.setAttribute("maxLength", "120");
        element2.setTextContent(this.getLabel());
        element2 = (Element)element.appendChild(document.createElementNS("ddi:reusable:3_0", "Label"));
        element2.setAttribute("type", "name");
        element2.setAttribute("maxLength", "8");
        element2.setTextContent(this.getShortName());
        if (this.hasValueLabels() || this.getDDI3RepresentationType() != null) {
            Element element3 = (Element)element.appendChild(document.createElementNS("ddi:logicalproduct:3_0", "Representation"));
            if (this.variableRecord.writeFormatType == 4) {
                element3.setAttribute("measurementUnit", "$");
            }
            if (this.hasValueLabels()) {
                Element element4 = (Element)element3.appendChild(document.createElementNS("ddi:logicalproduct:3_0", "CodeRepresentation"));
                Element element5 = (Element)element4.appendChild(document.createElementNS("ddi:reusable:3_0", "CodeSchemeReference"));
                element2 = (Element)element5.appendChild(document.createElementNS("ddi:reusable:3_0", "ID"));
                if (string == null) {
                    string = this.getDDI3DefaultCodeSchemeID();
                }
                element2.setTextContent(string);
            } else {
                String string2 = this.getDDI3DataType();
                if (this.getDDI3RepresentationType() == DDI3RepresentationType.NUMERIC) {
                    element2 = (Element)element3.appendChild(document.createElementNS("ddi:logicalproduct:3_0", "NumericRepresentation"));
                    if (string2 != null) {
                        element2.setAttribute("type", string2);
                    }
                    element2.setAttribute("decimalPositions", "" + this.getDecimals());
                }
                if (this.getDDI3RepresentationType() == DDI3RepresentationType.DATETIME) {
                    element2 = (Element)element3.appendChild(document.createElementNS("ddi:logicalproduct:3_0", "DateTimeRepresentation"));
                    if (string2 != null) {
                        element2.setAttribute("type", string2);
                    }
                    element2.setAttribute("format", this.getSPSSFormat());
                }
                if (this.getDDI3RepresentationType() == DDI3RepresentationType.TEXT) {
                    element2 = (Element)element3.appendChild(document.createElementNS("ddi:logicalproduct:3_0", "TextRepresentation"));
                    element2.setAttribute("maxLength", "" + this.getLength());
                }
            }
        }
        return element;
    }

    public DDI3RepresentationType getDDI3RepresentationType() {
        DDI3RepresentationType dDI3RepresentationType = null;
        switch (this.variableRecord.writeFormatType) {
            case 0: 
            case 1: 
            case 2: 
            case 26: 
            case 27: {
                dDI3RepresentationType = DDI3RepresentationType.TEXT;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 17: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                dDI3RepresentationType = DDI3RepresentationType.NUMERIC;
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 28: 
            case 29: 
            case 30: 
            case 38: 
            case 39: {
                dDI3RepresentationType = DDI3RepresentationType.DATETIME;
            }
        }
        return dDI3RepresentationType;
    }

    public String getDDI3DataType() {
        String string = null;
        switch (this.variableRecord.writeFormatType) {
            case 0: 
            case 1: 
            case 2: 
            case 26: 
            case 27: {
                string = "String";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: {
                if (this.getDecimals() > 0) {
                    string = "Decimal";
                    break;
                }
                string = "BigInteger";
                break;
            }
            case 17: {
                string = "Double";
                break;
            }
            case 20: 
            case 23: 
            case 24: 
            case 28: 
            case 29: 
            case 30: 
            case 38: 
            case 39: {
                string = "Date";
                break;
            }
            case 21: {
                string = "Time";
                break;
            }
            case 22: 
            case 25: {
                string = "DateTime";
                break;
            }
            default: {
                string = null;
            }
        }
        return string;
    }

    public int getDecimals() {
        return this.variableRecord.writeFormatDecimals;
    }

    public String getLabel() {
        return this.variableRecord.label;
    }

    public int getLength() {
        return this.getLength(new FileFormatInfo(FileFormatInfo.Format.SPSS));
    }

    public int getLength(FileFormatInfo fileFormatInfo) {
        return this.variableRecord.writeFormatWidth;
    }

    public String getMeasureLabel() {
        String string = "";
        switch (this.measure) {
            case 1: {
                string = "Nominal";
                break;
            }
            case 2: {
                string = "Ordinal";
                break;
            }
            case 3: {
                string = "Scale";
            }
        }
        return string;
    }

    public String getName() {
        return this.variableName;
    }

    public abstract String getSPSSFormat();

    public String getShortName() {
        return this.variableShortName;
    }

    public abstract String getValueAsString(int var1, FileFormatInfo var2) throws SPSSFileException;

    public boolean hasValueLabels() {
        return !this.categoryMap.isEmpty();
    }

    public boolean isDate() {
        return this.valueLabelRecord != null;
    }

    public boolean isMissingValueCode(double d) {
        boolean bl = false;
        if (this.variableRecord.missingValueFormatCode > 0) {
            for (int i = 0; i < this.variableRecord.missingValueFormatCode; ++i) {
                if (d != SPSSUtils.byte8ToDouble(this.variableRecord.missingValue[i])) continue;
                bl = true;
                break;
            }
        } else if (this.variableRecord.missingValueFormatCode <= -2) {
            if (d >= SPSSUtils.byte8ToDouble(this.variableRecord.missingValue[0]) && d <= SPSSUtils.byte8ToDouble(this.variableRecord.missingValue[1])) {
                bl = true;
            } else if (this.variableRecord.missingValueFormatCode == -3 && d == SPSSUtils.byte8ToDouble(this.variableRecord.missingValue[2])) {
                bl = true;
            }
        }
        return bl;
    }

    public boolean isMissingValueCode(String string) {
        boolean bl = false;
        if (this.variableRecord.missingValueFormatCode > 0) {
            for (int i = 0; i < this.variableRecord.missingValueFormatCode; ++i) {
                String string2 = this.file.charset == null ? SPSSUtils.byte8ToString(this.variableRecord.missingValue[i]) : SPSSUtils.byte8ToString(this.variableRecord.missingValue[i], this.file.charset);
                if (string.compareToIgnoreCase(string2) != 0) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    static enum DDI3RepresentationType {
        TEXT,
        NUMERIC,
        DATETIME;

    }

    static enum VariableType {
        NUMERIC,
        STRING;

    }
}

