/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.plaf.synthetica.painter;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.plaf.synthetica.painter.Cacheable;
import de.javasoft.plaf.synthetica.painter.ImagePainter;
import de.javasoft.plaf.synthetica.painter.SyntheticaComponentPainter;
import de.javasoft.plaf.synthetica.util.HiDpi;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Insets;
import java.util.HashMap;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.plaf.synth.SynthContext;

public class SplitPanePainter
extends SyntheticaComponentPainter {
    public static final String UI_KEY = "Synthetica.SplitPanePainter";
    private static HashMap<String, Image> imgCache = new HashMap();

    protected SplitPanePainter() {
    }

    public static SplitPanePainter getInstance() {
        return SplitPanePainter.getInstance(null);
    }

    public static SplitPanePainter getInstance(SynthContext sc) {
        SyntheticaComponentPainter instance = (SyntheticaComponentPainter)instances.get(SplitPanePainter.getPainterClassName(sc, SplitPanePainter.class, UI_KEY));
        if (instance == null) {
            instance = SplitPanePainter.getInstance(sc, SplitPanePainter.class, UI_KEY);
        }
        return (SplitPanePainter)instance;
    }

    public void paintSplitPaneBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintSplitPaneBorder(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintSplitPaneDividerBackground(SynthContext sc, Graphics g, int x, int y, int w, int h) {
    }

    public void paintSplitPaneDragDivider(SynthContext sc, Graphics g, int x, int y, int w, int h, int orientation) {
        Insets sInsets;
        JComponent c = sc.getComponent();
        Insets dInsets = sInsets = this.getImageInsets("Synthetica.splitPaneDivider.background.insets", c);
        String imagePath = "Synthetica.splitPaneDragDivider";
        imagePath = orientation == 0 ? String.valueOf(imagePath) + ".x.background" : String.valueOf(imagePath) + ".y.background";
        if ((imagePath = this.resolveImagePath(imagePath, c)) != null) {
            int xPolicy = SyntheticaLookAndFeel.getBoolean("Synthetica.splitPaneDragDivider.background.horizontalTiled", c, false) ? 1 : 0;
            int yPolicy = SyntheticaLookAndFeel.getBoolean("Synthetica.splitPaneDragDivider.background.verticalTiled", c, false) ? 1 : 0;
            ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, xPolicy, yPolicy);
            imagePainter.draw();
        }
    }

    public void paintSplitPaneDividerForeground(SynthContext sc, Graphics g, int x, int y, int w, int h, int orientation) {
        Insets sInsets;
        JComponent c = sc.getComponent();
        Insets dInsets = sInsets = this.getImageInsets("Synthetica.splitPaneDivider.background.insets", c);
        String gripPath = null;
        String imagePath = "Synthetica.splitPaneDivider";
        if (orientation == 0) {
            gripPath = String.valueOf(imagePath) + ".x.grip";
            imagePath = String.valueOf(imagePath) + ".x.background";
        } else {
            gripPath = String.valueOf(imagePath) + ".y.grip";
            imagePath = String.valueOf(imagePath) + ".y.background";
        }
        if ((sc.getComponentState() & 2) > 0) {
            gripPath = String.valueOf(gripPath) + ".hover";
        }
        imagePath = this.resolveImagePath(imagePath, c);
        gripPath = this.resolveImagePath(gripPath, c);
        if (imagePath != null) {
            int xPolicy = SyntheticaLookAndFeel.getBoolean("Synthetica.splitPaneDivider.background.horizontalTiled", c, false) ? 1 : 0;
            int yPolicy = SyntheticaLookAndFeel.getBoolean("Synthetica.splitPaneDivider.background.verticalTiled", c, false) ? 1 : 0;
            ImagePainter imagePainter = new ImagePainter(g, x, y, w, h, imagePath, sInsets, dInsets, xPolicy, yPolicy);
            imagePainter.draw();
        }
        if (gripPath != null) {
            boolean scalingEnabled;
            Image image = imgCache.get(gripPath);
            if (image == null) {
                image = new ImageIcon(SyntheticaLookAndFeel.getResource(gripPath)).getImage();
                imgCache.put(gripPath, image);
            }
            int gripWidth = SyntheticaLookAndFeel.getInstance().scaleInteger(image.getWidth(null));
            int gripHeight = SyntheticaLookAndFeel.getInstance().scaleInteger(image.getHeight(null));
            int xPos = x + (w - gripWidth) / 2;
            int yPos = y + (h - gripHeight) / 2;
            if (orientation == 1 && w - 2 < gripWidth) {
                return;
            }
            if (orientation == 0 && h - 2 < gripHeight) {
                return;
            }
            boolean bl = scalingEnabled = SyntheticaLookAndFeel.getInstance().getScaleFactor() != 1.0f;
            if (scalingEnabled) {
                image = HiDpi.scaleImage(image, gripWidth, gripHeight);
            }
            g.drawImage(image, xPos, yPos, gripWidth, gripHeight, null);
        }
    }

    @Override
    public Cacheable.ScaleType getCacheScaleType(String id) {
        if (id.equals("paintSplitPaneBorder") || id.equals("paintSplitPaneBackground")) {
            return Cacheable.ScaleType.NINE_SQUARE;
        }
        return super.getCacheScaleType(id);
    }

    @Override
    public int getCacheHash(SynthContext sc, int w, int h, int meta, String id) {
        if (id.equals("paintSplitPaneBorder") || id.equals("paintSplitPaneBackground")) {
            return -1;
        }
        return super.getCacheHash(sc, w, h, meta, id);
    }
}

