/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.colormap;

import com.macrofocus.colormap.MutableColorMap;
import com.macrofocus.colormap.SimpleColorMap;
import com.macrofocus.common.interval.MutableInterval;
import com.macrofocus.common.interval.PropertyClosedInterval;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.palette.CustomPalette;
import com.macrofocus.palette.MutablePalette;
import com.macrofocus.palette.PaletteFactory;
import java.util.Set;
import java.util.TreeSet;
import jsinterop.annotations.JsType;

@JsType
public class ColorMapFactory<Color> {
    private final CPColorFactory<Color> a;
    private final PaletteFactory<Color> b;

    /*
     * WARNING - void declaration
     */
    public ColorMapFactory(CPColorFactory<Color> colorFactory, PaletteFactory<Color> paletteFactory) {
        void var2_2;
        void var1_1;
        this.a = var1_1;
        this.b = var2_2;
    }

    public PaletteFactory<Color> getPaletteFactory() {
        return this.b;
    }

    /*
     * WARNING - void declaration
     */
    public MutableColorMap createContinuousSequentialColorMap(double min, double max) {
        void var3_2;
        void var1_1;
        return this.createContinuousColorMap((double)var1_1, (double)var3_2, this.b.createDefaultSequentialPalette());
    }

    /*
     * WARNING - void declaration
     */
    public MutableColorMap createContinuousDivergingColorMap(double min, double max) {
        void var3_2;
        void var1_1;
        return this.createContinuousColorMap((double)var1_1, (double)var3_2, this.b.createDefaultDivergingPalette());
    }

    /*
     * WARNING - void declaration
     */
    public MutableColorMap createCategoricalSequentialColorMap(Set values) {
        void var1_1;
        return this.createCategoricalColorMap((Set)var1_1, false, this.b.createDefaultSequentialPalette());
    }

    /*
     * WARNING - void declaration
     */
    public MutableColorMap createCategoricalDivergingColorMap(Set values) {
        void var1_1;
        return this.createCategoricalColorMap((Set)var1_1, false, this.b.createDefaultDivergingPalette());
    }

    /*
     * WARNING - void declaration
     */
    public MutableColorMap createQualitativeColorMap(Set values) {
        void var1_1;
        return this.createCategoricalColorMap((Set)var1_1, true, this.b.createDefaultQualititativePalette());
    }

    /*
     * WARNING - void declaration
     */
    public MutableColorMap createContinuousColorMap(double min, double max, MutablePalette palette) {
        void var1_1;
        void var3_2;
        return new SimpleColorMap<Color>(this.a, (MutableInterval)new PropertyClosedInterval(min, (double)(var3_2 - var1_1)), palette);
    }

    /*
     * WARNING - void declaration
     */
    public MutableColorMap createCategoricalColorMap(Set values, boolean cyclic, MutablePalette palette) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new SimpleColorMap<Color>(this.a, (Set)var1_1, (boolean)var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public MutableColorMap createColorMap(MutableInterval interval, MutablePalette palette) {
        void var2_2;
        void var1_1;
        return new SimpleColorMap<Color>(this.a, (MutableInterval)var1_1, var2_2);
    }

    public MutableColorMap createAlphabeticalColorMap(Set values) {
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("A");
        treeSet.add("B");
        treeSet.add("C");
        return new SimpleColorMap<Color>(this.a, treeSet, false, this.b.createDefaultSequentialPalette());
    }

    /*
     * WARNING - void declaration
     */
    public MutableColorMap createAutoContinuousColorMap(Number mininum, Number maximum) {
        if (mininum != null && maximum != null) {
            void var2_2;
            void var1_1;
            if (mininum.doubleValue() < 0.0 && maximum.doubleValue() > 0.0) {
                double d2 = 0.0 - mininum.doubleValue();
                double d3 = maximum.doubleValue();
                double d4 = Math.max(d2, d3);
                return this.createContinuousDivergingColorMap(0.0 - d4, d4);
            }
            return this.createContinuousSequentialColorMap(var1_1.doubleValue(), var2_2.doubleValue());
        }
        return this.createContinuousSequentialColorMap(0.0, 0.0);
    }

    /*
     * WARNING - void declaration
     */
    public MutableColorMap createAutoSegmentedColorMap(Number mininum, Number maximum) {
        if (mininum != null && maximum != null) {
            void var2_2;
            void var1_1;
            if (mininum.doubleValue() < 0.0 && maximum.doubleValue() > 0.0) {
                double d2 = 0.0 - mininum.doubleValue();
                double d3 = maximum.doubleValue();
                double d4 = Math.max(d2, d3);
                double d5 = 0.0 - d4;
                double d6 = d4;
                double d7 = (d5 - mininum.doubleValue()) / (maximum.doubleValue() - mininum.doubleValue());
                double d8 = (d6 - mininum.doubleValue()) / (maximum.doubleValue() - mininum.doubleValue());
                double d9 = (d8 + d7) / 2.0;
                return this.createContinuousColorMap(mininum.doubleValue(), maximum.doubleValue(), new CustomPalette<Color>(this.a, new CustomPalette.Entry<Color>(d7, this.a.createRGBColor(255, 0, 0)), new CustomPalette.Entry<Color>(d9, this.a.getWhite()), new CustomPalette.Entry<Color>(d8, this.a.createRGBColor(0, 128, 0))));
            }
            return this.createContinuousColorMap(var1_1.doubleValue(), var2_2.doubleValue(), new CustomPalette<Color>(this.a, new CustomPalette.Entry<Color>(0.0, this.a.createRGBColor(255, 0, 0)), new CustomPalette.Entry<Color>(0.5, this.a.getWhite()), new CustomPalette.Entry<Color>(1.0, this.a.createRGBColor(0, 128, 0))));
        }
        return this.createContinuousColorMap(0.0, 0.0, new CustomPalette<Color>(this.a, new CustomPalette.Entry<Color>(0.0, this.a.getWhite())));
    }
}

