/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.document.swing;

import com.macrofocus.application.document.Document;
import com.macrofocus.application.document.OpenDocumentException;
import com.macrofocus.application.document.View;
import com.macrofocus.application.document.swing.SwingSDIDocumentBasedApplication;
import com.macrofocus.application.window.CPWindow;
import com.macrofocus.common.command.AbstractUICommand;
import com.macrofocus.common.logging.Logging;
import java.awt.Component;
import java.awt.Toolkit;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.KeyStroke;

public class OpenURLUICommand<D extends Document, V extends View<JComponent, D>>
extends AbstractUICommand {
    private SwingSDIDocumentBasedApplication<D, V> application;
    private final CPWindow<JFrame, JComponent> window;

    public OpenURLUICommand(SwingSDIDocumentBasedApplication<D, V> application, View view, CPWindow<JFrame, JComponent> window) {
        super(view.getProperties().getProperty((Object)"action.openurl.label"), KeyStroke.getKeyStroke(85, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()).toString());
        this.application = application;
        this.window = window;
    }

    public void execute(Object source) {
        String url = JOptionPane.showInputDialog((Component)this.window.getNativeWindow(), "URL: ", "Open URL", 3);
        if (url != null) {
            CPWindow<JFrame, JComponent> newWindow = this.application.createWindow();
            try {
                Document document = this.application.openRemoteDocument(url, url, null);
                this.application.setup(newWindow, this.application.createView((JFrame)newWindow.getNativeWindow(), document));
            }
            catch (OpenDocumentException e) {
                Logging.getInstance().process((Throwable)e);
            }
        }
    }
}

