/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.window;

import com.macrofocus.application.document.View;
import com.macrofocus.application.document.swing.SwingSDIDocumentBasedApplication;
import com.macrofocus.application.window.AbstractWindowManager;
import com.macrofocus.application.window.CPWindow;
import com.macrofocus.application.window.SwingWindow;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class SwingSDIWindowManager<V extends View<JComponent, ?>>
extends AbstractWindowManager<JFrame, V, JComponent> {
    private final SwingSDIDocumentBasedApplication application;
    private SwingWindow window;
    private int windowCount;
    private JComponent currentComponent;

    public SwingSDIWindowManager(SwingSDIDocumentBasedApplication application) {
        this.application = application;
        this.windowCount = 0;
        this.currentComponent = null;
    }

    public int getWindowCount() {
        return this.windowCount;
    }

    public SwingWindow createWindow() {
        ++this.windowCount;
        if (this.window == null) {
            this.window = new SwingWindow();
            this.configureWindow(this.window);
            this.window.getNativeWindow().setSize(1000, 720);
            this.window.getNativeWindow().setLocationRelativeTo(null);
            this.window.getNativeWindow().setVisible(true);
        } else {
            if (Toolkit.getDefaultToolkit().isFrameStateSupported(1) && SwingSDIWindowManager.isFrameMinimized(this.window)) {
                this.window.getNativeWindow().setState(0);
            }
            this.window.getNativeWindow().toFront();
            this.window.getNativeWindow().requestFocus();
        }
        return this.window;
    }

    static boolean isFrameMinimized(CPWindow<JFrame, JComponent> frame) {
        return (((JFrame)frame.getNativeWindow()).getExtendedState() & 1) != 0;
    }

    protected void configureWindow(final CPWindow<JFrame, JComponent> window) {
        ((JFrame)window.getNativeWindow()).setDefaultCloseOperation(0);
        ((JFrame)window.getNativeWindow()).addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                SwingSDIWindowManager.this.closeWindow((CPWindow<JFrame, JComponent>)window);
            }
        });
        this.application.configureWindow((JFrame)window.getNativeWindow());
    }

    public CPWindow<JFrame, JComponent> getNewWindow() {
        return this.createWindow();
    }

    public void closeWindow(CPWindow<JFrame, JComponent> window) {
        if (this.currentComponent != null) {
            ((JFrame)window.getNativeWindow()).getContentPane().remove(this.currentComponent);
        }
        --this.windowCount;
    }

    public void assign(JComponent component, CPWindow<JFrame, JComponent> window, boolean newView) {
        this.currentComponent = component;
    }

    public CPWindow<JFrame, JComponent> getActiveWindow() {
        return this.window;
    }
}

