/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.table;

import de.javasoft.syntheticaaddons.SyntheticaAddonsUtilities;
import de.javasoft.syntheticaaddons.table.AbstractTableCellRenderer;
import de.javasoft.syntheticaaddons.table.ObjectTableCellRenderer;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import org.jdesktop.swingx.JXHyperlink;

public class HyperlinkTableCellRenderer
extends AbstractTableCellRenderer<JXHyperlink>
implements MouseListener,
MouseMotionListener {
    private int row;
    private int col;

    public HyperlinkTableCellRenderer(TableCellRenderer defaultRenderer) {
        super(defaultRenderer);
    }

    @Override
    protected JXHyperlink createRendererComponent() {
        JXHyperlink c = new JXHyperlink();
        return c;
    }

    @Override
    protected void setValue(JXHyperlink rendererComponent, Object value) {
        rendererComponent.setAction((Action)new AbstractAction(value.toString()){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SyntheticaAddonsUtilities.openInBrowser((String)this.getValue("Name"));
            }
        });
    }

    @Override
    protected void configureRendererComponent(JXHyperlink rendererComponent, JComponent defaultRendererComponent, JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            super.configureRendererComponent(rendererComponent, defaultRendererComponent, table, value, isSelected, hasFocus, row, column);
        }
        boolean rollover = !table.isEditing() && this.row == row && this.col == column;
        rendererComponent.getModel().setRollover(rollover);
    }

    @Override
    public void mouseClicked(MouseEvent evt) {
        Component c;
        JTable table = (JTable)evt.getSource();
        TableCellRenderer r = table.getCellRenderer(this.row, this.col);
        if (r instanceof ObjectTableCellRenderer) {
            r = (ObjectTableCellRenderer)table.getCellRenderer(this.row, this.col);
        }
        if ((c = r.getTableCellRendererComponent(table, table.getValueAt(this.row, this.col), false, false, this.row, this.col)) instanceof HyperlinkTableCellRenderer) {
            ((JXHyperlink)this.rendererComponent).getAction().actionPerformed(new ActionEvent(this.rendererComponent, 1001, ""));
        }
    }

    @Override
    public void mouseExited(MouseEvent evt) {
        JTable table = (JTable)evt.getSource();
        this.row = -1;
        this.col = -1;
        table.repaint();
    }

    @Override
    public void mousePressed(MouseEvent evt) {
    }

    @Override
    public void mouseReleased(MouseEvent evt) {
    }

    @Override
    public void mouseEntered(MouseEvent evt) {
    }

    @Override
    public void mouseMoved(MouseEvent evt) {
        JTable table = (JTable)evt.getSource();
        Point pt = evt.getPoint();
        this.row = table.rowAtPoint(pt);
        this.col = table.columnAtPoint(pt);
        if (this.row < 0 || this.col < 0) {
            this.row = -1;
            this.col = -1;
        }
        table.repaint();
    }

    @Override
    public void mouseDragged(MouseEvent evt) {
    }
}

