/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.syntheticaaddons.table;

import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.syntheticaaddons.table.AbstractTableCellRenderer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import javax.swing.JTextField;
import javax.swing.table.TableCellRenderer;

public class IntegerGroupTableCellRenderer
extends AbstractTableCellRenderer<JTextField> {
    private String delimiter;

    public IntegerGroupTableCellRenderer(TableCellRenderer defaultRenderer) {
        this(defaultRenderer, ',');
    }

    public IntegerGroupTableCellRenderer(TableCellRenderer defaultRenderer, char delimiter) {
        super(defaultRenderer);
        this.delimiter = String.valueOf(delimiter);
    }

    @Override
    protected JTextField createRendererComponent() {
        JTextField c = new JTextField();
        c.setBorder(SyntheticaLookAndFeel.getInstance().createEmptyBorder(0, 0, 0, 0, true));
        c.putClientProperty("Synthetica.opaque", false);
        return c;
    }

    @Override
    protected void setValue(JTextField rendererComponent, Object value) {
        String s = null;
        if (value.getClass() == Integer.class) {
            s = value.toString();
        } else if (value.getClass() == Point.class) {
            Point p = (Point)value;
            s = String.valueOf(p.x) + this.delimiter + " " + p.y;
        } else if (value.getClass() == Dimension.class) {
            Dimension d = (Dimension)value;
            s = String.valueOf(d.width) + this.delimiter + " " + d.height;
        } else if (value.getClass() == Rectangle.class) {
            Rectangle r = (Rectangle)value;
            s = String.valueOf(r.x) + this.delimiter + " " + r.y + this.delimiter + " " + r.width + this.delimiter + " " + r.height;
        } else if (value.getClass() == Insets.class) {
            Insets insets = (Insets)value;
            s = String.valueOf(insets.top) + this.delimiter + " " + insets.left + this.delimiter + " " + insets.bottom + this.delimiter + " " + insets.right;
        } else if (value.getClass() == Color.class) {
            Color color = (Color)value;
            s = String.valueOf(color.getRed()) + this.delimiter + " " + color.getGreen() + this.delimiter + " " + color.getBlue() + this.delimiter + " " + color.getAlpha();
        }
        rendererComponent.setText(s);
    }
}

