/*
 * Decompiled with CFR 0.152.
 */
package de.javasoft.button.ui;

import de.javasoft.button.ui.BasicJYButtonUI;
import de.javasoft.plaf.synthetica.SyntheticaLookAndFeel;
import de.javasoft.widgets.util.WidgetUtils;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.InsetsUIResource;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.synth.ColorType;
import javax.swing.plaf.synth.Region;
import javax.swing.plaf.synth.SynthContext;
import javax.swing.plaf.synth.SynthLookAndFeel;
import javax.swing.plaf.synth.SynthStyle;
import javax.swing.text.View;

public class SyntheticaJYButtonUI
extends BasicJYButtonUI {
    public static ComponentUI createUI(JComponent c) {
        return new SyntheticaJYButtonUI();
    }

    @Override
    protected void installDefaults(AbstractButton c) {
        Border border;
        super.installDefaults(c);
        Font f = c.getFont();
        if (f == null || f instanceof UIResource) {
            if (UIManager.getFont("Button.font") == null) {
                c.setFont(new FontUIResource(SyntheticaLookAndFeel.getFontName(), 0, SyntheticaLookAndFeel.getFontSize()));
            } else {
                c.setFont(new FontUIResource(UIManager.getFont("Button.font").deriveFont(0)));
            }
        }
        c.setOpaque(false);
        SynthStyle ss = SynthLookAndFeel.getStyle(c, Region.BUTTON);
        SynthContext sc = new SynthContext(c, Region.BUTTON, ss, 0);
        Insets defaultMargin = (Insets)ss.get(sc, "Button.margin");
        Insets defaultInsets = ss.getInsets(sc, null);
        this.textShiftOffset = ss.getInt(sc, "Button.textShiftOffset", 0);
        Insets margin = c.getMargin();
        if (margin == null || margin instanceof UIResource) {
            c.setMargin(new InsetsUIResource(defaultMargin.top, defaultMargin.left, defaultMargin.bottom, defaultMargin.right));
        }
        if ((border = c.getBorder()) == null || border instanceof UIResource) {
            c.setBorder(WidgetUtils.createRotatableEmptyBorder(defaultInsets, true));
        }
        LookAndFeel.installProperty(c, "rolloverEnabled", Boolean.TRUE);
    }

    @Override
    protected void paintButtonText(AbstractButton button, String text, Graphics g, FontMetrics fm, Rectangle textRect) {
        View v = (View)button.getClientProperty("html");
        if (v != null) {
            v.paint(g, textRect);
        } else {
            SynthStyle ss = SynthLookAndFeel.getStyle(button, Region.BUTTON);
            SynthContext sc = new SynthContext(button, Region.BUTTON, ss, button.isEnabled() ? 0 : 8);
            Color color = button.isEnabled() ? button.getForeground() : ss.getColor(sc, ColorType.TEXT_FOREGROUND);
            g.setColor(color);
            ss.getGraphicsUtils(sc).paintText(sc, g, text, textRect.x, textRect.y, button.getDisplayedMnemonicIndex());
        }
    }
}

