/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.array;

import com.macrofocus.data.array.ArrayModel;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.StringTokenizer;

public class SimpleArrayModel
implements ArrayModel,
Externalizable {
    static final long serialVersionUID = 3240936955671106933L;
    private Object[] values;
    private boolean[] available;

    public SimpleArrayModel() {
    }

    public SimpleArrayModel(String value) {
        StringTokenizer st = new StringTokenizer(value, ",");
        int count = st.countTokens();
        this.values = new Object[count];
        this.available = new boolean[count];
        for (int index = 0; index < count; ++index) {
            this.values[index] = st.nextToken().trim();
            this.available[index] = true;
        }
    }

    @Override
    public Object getObject(int index) {
        return this.values[index];
    }

    @Override
    public boolean isAvailable(int index) {
        return this.available[index];
    }

    @Override
    public int getObjectCount() {
        return this.values.length;
    }

    public String toString() {
        Object string = "";
        for (int index = 0; index < this.getObjectCount(); ++index) {
            string = (String)string + this.getObject(index).toString();
            if (index + 1 >= this.getObjectCount()) continue;
            string = (String)string + ",";
        }
        return string;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int i;
        out.writeInt(10000);
        out.writeInt(this.values.length);
        for (i = 0; i < this.getObjectCount(); ++i) {
            out.writeBoolean(this.isAvailable(i));
        }
        for (i = 0; i < this.getObjectCount(); ++i) {
            if (!this.isAvailable(i)) continue;
            out.writeObject(this.getObject(i));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version == 10000) {
            int i;
            int size = in.readInt();
            this.available = new boolean[size];
            this.values = new Object[size];
            for (i = 0; i < size; ++i) {
                this.available[i] = in.readBoolean();
            }
            for (i = 0; i < size; ++i) {
                if (!this.isAvailable(i)) continue;
                this.values[i] = in.readObject();
            }
        }
    }
}

