/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.cleaning;

import com.macrofocus.data.DataModel;
import com.macrofocus.data.cleaning.AbstractRowExcluder;
import com.macrofocus.data.row.RowModel;
import java.util.Vector;

public class NotAvailableRowExcluder
extends AbstractRowExcluder {
    private final DataModel dataModel;
    private final Vector andColumns;
    private final Vector orColumns;

    public NotAvailableRowExcluder(DataModel dataModel) {
        this.dataModel = dataModel;
        this.andColumns = new Vector();
        this.orColumns = new Vector();
    }

    @Override
    public boolean exclude(RowModel rowModel) {
        int i;
        boolean value;
        boolean exclude = false;
        if (this.andColumns.size() > 0) {
            exclude = true;
            for (i = 0; i < this.andColumns.size() && exclude; exclude &= value, ++i) {
                value = !rowModel.isAvailable((Integer)this.andColumns.elementAt(i));
            }
        }
        for (i = 0; i < this.orColumns.size() && !exclude; exclude |= value, ++i) {
            value = !rowModel.isAvailable((Integer)this.orColumns.elementAt(i));
        }
        return exclude;
    }

    @Override
    public boolean exclude(int row) {
        int i;
        boolean value;
        boolean exclude = false;
        if (this.andColumns.size() > 0) {
            exclude = true;
            for (i = 0; i < this.andColumns.size() && exclude; exclude &= value, ++i) {
                value = !this.dataModel.isAvailable(row, (Integer)this.andColumns.elementAt(i));
            }
        }
        for (i = 0; i < this.orColumns.size() && !exclude; exclude |= value, ++i) {
            value = !this.dataModel.isAvailable(row, (Integer)this.orColumns.elementAt(i));
        }
        return exclude;
    }

    public void addAnd(Object column) {
        int index = this.dataModel.getColumnIndex(column);
        if (index != -1) {
            this.andColumns.addElement(index);
        }
    }

    public void addOr(Object column) {
        int index = this.dataModel.getColumnIndex(column);
        if (index != -1) {
            this.orColumns.addElement(index);
        }
    }
}

