/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.column;

import com.macrofocus.data.DataModel;
import com.macrofocus.data.column.AbstractColumnModel;

public class DataModelColumnModel<O>
extends AbstractColumnModel<O> {
    private final int column;
    private final DataModel dataModel;

    public DataModelColumnModel(DataModel dataModel, int column) {
        this.dataModel = dataModel;
        this.column = column;
    }

    @Override
    public boolean isAvailable(int row) {
        return this.dataModel.isAvailable(row, this.column);
    }

    @Override
    public O getObject(int row) {
        return (O)this.dataModel.getValueAt(row, this.column);
    }

    @Override
    public Class getMembership() {
        return this.dataModel.getColumnClass(this.column);
    }

    @Override
    public Object getName() {
        return this.dataModel.getColumnName(this.column);
    }

    @Override
    public int getRowCount() {
        return this.dataModel.getRowCount();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DataModelColumnModel)) {
            return false;
        }
        DataModelColumnModel dataModelColumnModel = (DataModelColumnModel)o;
        if (this.column != dataModelColumnModel.column) {
            return false;
        }
        return this.dataModel != null ? this.dataModel.equals(dataModelColumnModel.dataModel) : dataModelColumnModel.dataModel == null;
    }

    public int hashCode() {
        int result = this.column;
        result = 29 * result + (this.dataModel != null ? this.dataModel.hashCode() : 0);
        return result;
    }
}

