/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.db;

import com.macrofocus.data.db.DatabaseDriver;
import com.macrofocus.data.db.JDBCTypes;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.swing.table.TableModel;
import org.locationtech.jts.geom.Geometry;

public abstract class JDBCDatabaseDriver
implements DatabaseDriver {
    protected JDBCDatabaseDriver() {
        try {
            Class.forName(this.getClassName()).newInstance();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }

    @Override
    public Connection getConnection(String url, String username, String password) throws SQLException {
        Connection connection = null;
        if (username != null) {
            try {
                connection = DriverManager.getConnection(url, username, password);
            }
            catch (SQLException e) {
                try {
                    connection = DriverManager.getConnection(url);
                }
                catch (SQLException e1) {
                    throw e;
                }
            }
        } else {
            connection = DriverManager.getConnection(url);
        }
        return connection;
    }

    public Connection getConnection(String url, Properties info) throws SQLException {
        Connection connection = null;
        try {
            connection = DriverManager.getConnection(url, info);
        }
        catch (SQLException e) {
            try {
                connection = DriverManager.getConnection(url);
            }
            catch (SQLException e1) {
                throw e;
            }
        }
        return connection;
    }

    @Override
    public Class getColumnType(ResultSetMetaData metaData, int column) throws SQLException {
        int type = metaData.getColumnType(column);
        return JDBCTypes.getType(type);
    }

    public String getColumnType(Class type, int precision) {
        if (type == Boolean.class) {
            return "boolean";
        }
        if (type == Integer.class) {
            return "int";
        }
        if (type == Long.class) {
            return "bigint";
        }
        if (type == Float.class) {
            return "real";
        }
        if (type == Double.class) {
            return "double";
        }
        if (type == BigDecimal.class) {
            return "decimal";
        }
        if (type == String.class) {
            if (precision > 0) {
                if (precision > 255) {
                    return "text";
                }
                return "varchar(" + precision + ")";
            }
            return "varchar";
        }
        if (type == Date.class) {
            return "date";
        }
        if (type == byte[].class) {
            return "binary";
        }
        if (Geometry.class.isAssignableFrom(type)) {
            return "binary";
        }
        throw new UnsupportedOperationException("Unknown type " + String.valueOf(type));
    }

    @Override
    public Object getColumnValue(ResultSet rs, Class columnType, int column) throws SQLException {
        Object object;
        if (columnType.equals(String.class)) {
            object = rs.getString(column);
        } else if (columnType.equals(Integer.class)) {
            object = rs.getInt(column);
        } else if (columnType.equals(Byte.class)) {
            object = rs.getByte(column);
        } else if (columnType.equals(Short.class)) {
            object = rs.getShort(column);
        } else if (columnType.equals(Long.class)) {
            object = rs.getLong(column);
        } else if (columnType.equals(Float.class)) {
            object = Float.valueOf(rs.getFloat(column));
        } else if (columnType.equals(Double.class)) {
            object = rs.getDouble(column);
        } else if (columnType.equals(BigDecimal.class)) {
            object = rs.getBigDecimal(column);
        } else if (columnType.equals(Boolean.class)) {
            object = rs.getBoolean(column);
        } else if (columnType.equals(Date.class)) {
            object = rs.getDate(column);
        } else if (columnType.equals(Timestamp.class)) {
            object = rs.getTimestamp(column);
        } else {
            object = rs.getObject(column);
            Class<?> cl = object != null ? object.getClass() : null;
            System.err.println("JDBCDatabaseDriver: Unknown class " + String.valueOf(columnType) + " for value " + String.valueOf(cl));
        }
        if (rs.wasNull()) {
            object = null;
        }
        return object;
    }

    protected static boolean exist(String className) {
        Class<?> cl;
        try {
            cl = Class.forName(className, false, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return cl != null;
    }

    @Override
    public String getURL(String host, String schema, String username, String password) {
        String url = "jdbc:" + this.getPrefix() + ":";
        if (host != null) {
            url = url + "//" + host + "/";
        }
        if (schema != null) {
            url = url + schema;
        }
        return url;
    }

    @Override
    public String getQuery(String query) {
        return query + ";";
    }

    @Override
    public Iterable<String> getDatabases(String host, String username, String password) throws SQLException {
        Connection conn = this.getConnection(this.getURL(host, null, username, password), username, password);
        ArrayList<String> databases = new ArrayList<String>();
        ResultSet schemas = conn.getMetaData().getSchemas();
        while (schemas.next()) {
            databases.add(schemas.getString(1));
        }
        return databases;
    }

    @Override
    public Iterable<String> getTables(String url, String database, String username, String password) throws SQLException {
        Connection conn = this.getConnection(url, username, password);
        String[] types = new String[]{"TABLE", "VIEW"};
        return this.getTables(conn, types);
    }

    private List<String> getTables(Connection conn, String[] types) throws SQLException {
        ArrayList<String> tables = new ArrayList<String>();
        DatabaseMetaData meta = conn.getMetaData();
        ResultSet result = meta.getTables(null, null, null, types);
        while (result.next()) {
            String schema = result.getString("TABLE_SCHEM");
            String table = result.getString("TABLE_NAME");
            tables.add((String)(schema != null ? schema + "." + table : table));
        }
        return tables;
    }

    @Override
    public String createTable(String table, TableModel tableModel, ResultSetMetaData md, ResultSet primary) throws SQLException {
        StringBuffer result = new StringBuffer();
        result.append("CREATE TABLE ");
        result.append(table);
        result.append(" ( ");
        for (int column = 0; column < tableModel.getColumnCount(); ++column) {
            int i = column + 1;
            if (i != 1) {
                result.append(',');
            }
            result.append("`" + md.getColumnName(i) + "`");
            result.append(' ');
            String type = this.getColumnType(tableModel.getColumnClass(column), md.getPrecision(i));
            result.append(type);
            if (md.isNullable(i) == 0) {
                result.append(" NOT NULL");
            } else {
                result.append(" NULL");
            }
            if (!md.isAutoIncrement(i)) continue;
            result.append(" auto_increment");
        }
        if (primary != null) {
            boolean first = true;
            while (primary.next()) {
                if (first) {
                    first = false;
                    result.append(',');
                    result.append("PRIMARY KEY(");
                } else {
                    result.append(",");
                }
                result.append("`" + primary.getString("COLUMN_NAME") + "`");
            }
            if (!first) {
                result.append(')');
            }
        }
        result.append(")");
        return result.toString();
    }

    @Override
    public String createTable(String table, TableModel tableModel, String ... primary) throws SQLException {
        StringBuffer result = new StringBuffer();
        result.append("CREATE TABLE `");
        result.append(table);
        result.append("` (");
        for (int column = 0; column < tableModel.getColumnCount(); ++column) {
            int i = column + 1;
            if (i != 1) {
                result.append(',');
            }
            result.append("`");
            result.append(tableModel.getColumnName(column));
            result.append("` ");
            String type = this.getColumnType(tableModel, column);
            result.append(type);
        }
        if (primary != null) {
            boolean first = true;
            for (String s : primary) {
                if (first) {
                    first = false;
                    result.append(',');
                    result.append("PRIMARY KEY(");
                } else {
                    result.append(",");
                }
                result.append("`" + s + "`");
            }
            if (!first) {
                result.append(')');
            }
        }
        result.append(")");
        return result.toString();
    }

    private final String getColumnType(TableModel tableModel, int column) {
        if (tableModel.getColumnClass(column) == String.class) {
            int min = Integer.MAX_VALUE;
            int max = 0;
            int missing = 0;
            for (int row = 0; row < tableModel.getRowCount(); ++row) {
                String value = (String)tableModel.getValueAt(row, column);
                if (value != null) {
                    int length = value.length();
                    if (length > max) {
                        max = length;
                    }
                    if (length >= min) continue;
                    min = length;
                    continue;
                }
                ++missing;
            }
            if (missing == 0 && min > 0 && min == max) {
                return "char(" + max + ")";
            }
            if (max < 256) {
                return "varchar(255)";
            }
            return "text";
        }
        return this.getColumnType(tableModel.getColumnClass(column), 0);
    }

    @Override
    public void dropTable(Connection connection, String table) throws SQLException {
        String[] types = new String[]{"TABLE"};
        if (this.getTables(connection, types).contains(table)) {
            connection.prepareStatement("DROP TABLE " + table).execute();
        }
    }

    @Override
    public String generateParseDate(String date) {
        return "PARSEDATETIME('" + date + "', 'yyyy-MM-dd')";
    }

    @Override
    public String generateIsNull(String value) {
        return value + " IS NULL";
    }

    @Override
    public boolean isNetworkEnabled() {
        return true;
    }

    protected abstract String getClassName();

    protected abstract String getPrefix();
}

