/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.matrix;

import com.macrofocus.common.logging.Logging;
import com.macrofocus.data.DataModel;
import com.macrofocus.data.matrix.AbstractMatrixModel;
import com.macrofocus.data.matrix.MatrixModel;
import com.macrofocus.data.reader.DataReader;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Vector;

public final class SimpleMatrixModel
extends AbstractMatrixModel
implements Externalizable {
    static final long serialVersionUID = -4851670709070124342L;
    private double[][] array;
    private boolean[][] isAvailable;
    private Object[] name;
    private int rowCount;
    private int columnCount;

    public SimpleMatrixModel() {
    }

    public SimpleMatrixModel(MatrixModel matrixModel) {
        this.columnCount = matrixModel.getColumnCount();
        this.rowCount = matrixModel.getRowCount();
        this.array = new double[this.rowCount][this.columnCount];
        this.isAvailable = new boolean[this.rowCount][this.columnCount];
        this.name = new Object[this.columnCount];
        for (int column = 0; column < matrixModel.getColumnCount(); ++column) {
            this.name[column] = matrixModel.getColumnName(column);
            for (int row = 0; row < matrixModel.getRowCount(); ++row) {
                if (matrixModel.isAvailable(row, column)) {
                    this.array[row][column] = matrixModel.getDouble(row, column);
                    this.isAvailable[row][column] = true;
                    continue;
                }
                this.isAvailable[row][column] = false;
            }
        }
    }

    private SimpleMatrixModel(int rowCount, int columnCount) {
        this.rowCount = rowCount;
        this.columnCount = columnCount;
        this.array = new double[rowCount][columnCount];
        this.isAvailable = new boolean[rowCount][columnCount];
        this.name = new Object[columnCount];
        for (int column = 0; column < this.getColumnCount(); ++column) {
            this.name[column] = "Column " + column;
            for (int row = 0; row < this.getRowCount(); ++row) {
                this.isAvailable[row][column] = false;
            }
        }
    }

    public SimpleMatrixModel(double[][] array) {
        this.array = array;
        this.rowCount = array.length;
        if (this.getRowCount() > 0) {
            this.columnCount = array[0].length;
            this.isAvailable = new boolean[this.rowCount][this.columnCount];
            this.name = new Object[this.columnCount];
            for (int column = 0; column < this.getColumnCount(); ++column) {
                this.name[column] = "Column " + column;
                for (int row = 0; row < this.getRowCount(); ++row) {
                    this.isAvailable[row][column] = super.isAvailable(row, column);
                }
            }
        } else {
            this.columnCount = 0;
            this.isAvailable = new boolean[this.rowCount][this.columnCount];
            this.name = new Object[this.columnCount];
        }
    }

    public SimpleMatrixModel(int rowCount, int columnCount, double s) {
        this(rowCount, columnCount);
        for (int row = 0; row < this.getRowCount(); ++row) {
            for (int column = 0; column < this.getColumnCount(); ++column) {
                this.array[row][column] = s;
                this.isAvailable[row][column] = true;
            }
        }
    }

    public SimpleMatrixModel(DataModel dataModel) {
        int column;
        int numberCount = 0;
        for (column = 0; column < dataModel.getColumnCount(); ++column) {
            if (!Number.class.isAssignableFrom(dataModel.getColumnClass(column))) continue;
            ++numberCount;
        }
        this.columnCount = numberCount;
        this.rowCount = dataModel.getRowCount();
        this.array = new double[this.rowCount][this.columnCount];
        this.isAvailable = new boolean[this.rowCount][this.columnCount];
        this.name = new Object[this.columnCount];
        column = 0;
        for (int dataModelColumn = 0; dataModelColumn < dataModel.getColumnCount(); ++dataModelColumn) {
            if (!Number.class.isAssignableFrom(dataModel.getColumnClass(dataModelColumn))) continue;
            this.name[column] = dataModel.getColumnName(dataModelColumn);
            for (int row = 0; row < dataModel.getRowCount(); ++row) {
                if (dataModel.isAvailable(row, dataModelColumn)) {
                    this.array[row][column] = ((Number)dataModel.getValueAt(row, dataModelColumn)).doubleValue();
                    this.isAvailable[row][column] = true;
                    continue;
                }
                this.isAvailable[row][column] = false;
            }
            ++column;
        }
    }

    public SimpleMatrixModel(DataReader reader) {
        Vector xxx = new Vector();
        try {
            this.name = new Object[reader.getColumnCount()];
            Class[] classes = new Class[reader.getColumnCount()];
            for (int i = 0; i < reader.getColumnCount(); ++i) {
                this.name[i] = reader.getColumnName(i);
                classes[i] = reader.getClass(i);
            }
            if (reader.getRowCount() == -1) {
                int i;
                while (reader.hasMoreRow()) {
                    reader.nextRow();
                    if (!reader.hasMoreColumn()) break;
                    Vector<Object> vector = new Vector<Object>(reader.getColumnCount());
                    for (i = 0; i < reader.getColumnCount(); ++i) {
                        if (!reader.hasMoreColumn()) continue;
                        Object feature = reader.nextColumn();
                        vector.addElement(feature);
                    }
                    xxx.addElement(vector);
                }
                this.array = new double[xxx.size()][reader.getColumnCount()];
                this.isAvailable = new boolean[xxx.size()][reader.getColumnCount()];
                for (int j = 0; j < reader.getColumnCount(); ++j) {
                    for (i = 0; i < xxx.size(); ++i) {
                        Object value = ((Vector)xxx.elementAt(i)).elementAt(j);
                        if (value != null) {
                            this.array[i][j] = ((Number)value).doubleValue();
                            this.isAvailable[i][j] = true;
                            continue;
                        }
                        this.isAvailable[i][j] = false;
                    }
                }
                this.rowCount = xxx.size();
                this.columnCount = reader.getColumnCount();
            } else {
                this.array = new double[reader.getRowCount()][reader.getColumnCount()];
                this.isAvailable = new boolean[reader.getRowCount()][reader.getColumnCount()];
                for (int row = 0; row < reader.getRowCount(); ++row) {
                    for (int column = 0; column < reader.getColumnCount(); ++column) {
                        Object value = reader.nextColumn();
                        if (value != null) {
                            this.array[row][column] = ((Number)value).doubleValue();
                            this.isAvailable[row][column] = true;
                            continue;
                        }
                        this.isAvailable[row][column] = false;
                    }
                    reader.nextRow();
                }
                this.rowCount = reader.getRowCount();
                this.columnCount = reader.getColumnCount();
            }
        }
        catch (Exception e) {
            Logging.getInstance().process((Throwable)e);
            System.out.println("Error in reading line number " + reader.getLineNumber());
            this.rowCount = 0;
            this.columnCount = 0;
        }
    }

    @Override
    public boolean isAvailable(int row, int column) {
        return this.isAvailable[row][column];
    }

    @Override
    public Object getColumnName(int column) {
        try {
            return this.name[column];
        }
        catch (Exception e) {
            System.err.println("Invalid column: " + column);
            return null;
        }
    }

    @Override
    public int getColumnIndex(Object name) {
        int index = -1;
        for (int i = 0; i < this.getColumnCount(); ++i) {
            if (!this.getColumnName(i).equals(name)) continue;
            index = i;
            break;
        }
        return index;
    }

    @Override
    public int getRowCount() {
        return this.rowCount;
    }

    @Override
    public int getColumnCount() {
        return this.columnCount;
    }

    @Override
    public double getDouble(int row, int column) {
        return this.array[row][column];
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "[rowCount=" + this.rowCount + ",columnCount=" + this.columnCount + "]";
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        int column;
        int row;
        out.writeInt(10000);
        out.writeInt(this.getRowCount());
        out.writeInt(this.getColumnCount());
        for (int column2 = 0; column2 < this.getColumnCount(); ++column2) {
            out.writeObject(this.name[column2]);
        }
        for (row = 0; row < this.getRowCount(); ++row) {
            for (column = 0; column < this.getColumnCount(); ++column) {
                out.writeBoolean(this.isAvailable[row][column]);
            }
        }
        for (row = 0; row < this.getRowCount(); ++row) {
            for (column = 0; column < this.getColumnCount(); ++column) {
                if (!this.isAvailable(row, column)) continue;
                out.writeDouble(this.array[row][column]);
            }
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int version = in.readInt();
        if (version > 0) {
            int column;
            int row;
            this.rowCount = in.readInt();
            this.columnCount = in.readInt();
            this.name = new Object[this.columnCount];
            this.isAvailable = new boolean[this.rowCount][this.columnCount];
            this.array = new double[this.rowCount][this.columnCount];
            for (int column2 = 0; column2 < this.columnCount; ++column2) {
                this.name[column2] = in.readObject();
            }
            for (row = 0; row < this.getRowCount(); ++row) {
                for (column = 0; column < this.getColumnCount(); ++column) {
                    this.isAvailable[row][column] = in.readBoolean();
                }
            }
            for (row = 0; row < this.getRowCount(); ++row) {
                for (column = 0; column < this.getColumnCount(); ++column) {
                    if (!this.isAvailable(row, column)) continue;
                    this.array[row][column] = in.readDouble();
                }
            }
        }
    }
}

