/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.matrix.vector;

import com.macrofocus.data.matrix.MatrixModel;
import com.macrofocus.data.matrix.vector.AbstractVectorModel;

public class AverageVectorModel
extends AbstractVectorModel {
    private double[] vector;
    private boolean[] isAvailable;
    private Object name;

    public AverageVectorModel(MatrixModel matrixModel) {
        this("Average", matrixModel);
    }

    public AverageVectorModel(Object name, MatrixModel matrixModel) {
        this.name = name;
        this.vector = new double[matrixModel.getRowCount()];
        this.isAvailable = new boolean[matrixModel.getRowCount()];
        for (int row = 0; row < matrixModel.getRowCount(); ++row) {
            double sum = 0.0;
            int count = 0;
            for (int column = 0; column < matrixModel.getColumnCount(); ++column) {
                if (!matrixModel.isAvailable(row, column)) continue;
                sum += matrixModel.getDouble(row, column);
                ++count;
            }
            if (count > 0) {
                this.vector[row] = sum / (double)count;
                this.isAvailable[row] = true;
                continue;
            }
            this.vector[row] = Double.NaN;
            this.isAvailable[row] = false;
        }
    }

    @Override
    public boolean isAvailable(int index) {
        return this.isAvailable[index];
    }

    @Override
    public double getDouble(int index) {
        return this.vector[index];
    }

    @Override
    public Object getName() {
        return this.name;
    }

    @Override
    public int getRowCount() {
        return this.vector.length;
    }
}

