/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.matrix.vector;

import com.macrofocus.data.matrix.vector.AbstractVectorModel;
import com.macrofocus.data.matrix.vector.SortedVectorModel;
import com.macrofocus.data.matrix.vector.VectorModel;

public class QuartilesVectorModel
extends AbstractVectorModel {
    private VectorModel sortedVectorModel;
    private double meanValue;
    private double medianValue;
    private double lowerQuartile;
    private double upperQuartile;
    private double standardDeviation;
    private double maxValue;
    private double minValue;
    private double lowValue;
    private double highValue;

    public QuartilesVectorModel(SortedVectorModel sortedVectorModel) {
        this.sortedVectorModel = sortedVectorModel;
        this.computeQuartiles(sortedVectorModel);
        this.computeMeanMinMax(sortedVectorModel);
        this.computeStandardDeviation(sortedVectorModel);
        this.computeHighLow(2.0);
    }

    public QuartilesVectorModel(VectorModel vectorModel) {
        this(new SortedVectorModel(vectorModel));
    }

    @Override
    public double getDouble(int index) {
        return this.sortedVectorModel.getDouble(index);
    }

    @Override
    public Object getName() {
        return this.sortedVectorModel.getName();
    }

    @Override
    public int getRowCount() {
        return this.sortedVectorModel.getRowCount();
    }

    private void computeQuartiles(VectorModel vectorModel) {
        this.medianValue = this.findMedian(vectorModel, 0, vectorModel.getRowCount() - 1);
        this.lowerQuartile = this.isEven(vectorModel.getRowCount()) ? this.findMedian(vectorModel, 0, vectorModel.getRowCount() / 2 - 1) : this.findMedian(vectorModel, 0, vectorModel.getRowCount() / 2);
        this.upperQuartile = this.findMedian(vectorModel, vectorModel.getRowCount() / 2, vectorModel.getRowCount() - 1);
    }

    private double findMedian(VectorModel vectorModel, int from, int to) {
        int length = to - from + 1;
        if (length <= 0) {
            return 0.0;
        }
        if (this.isEven(length)) {
            return (vectorModel.getDouble(from + length / 2) + vectorModel.getDouble(from + (length / 2 - 1))) / 2.0;
        }
        return vectorModel.getDouble(from + length / 2);
    }

    private boolean isEven(int a) {
        return a % 2 == 0;
    }

    private void computeHighLow(double range_factor) {
        this.highValue = this.upperQuartile + range_factor * (this.upperQuartile - this.lowerQuartile);
        if (this.highValue > this.maxValue) {
            this.highValue = this.maxValue;
        }
        this.lowValue = this.lowerQuartile - range_factor * (this.upperQuartile - this.lowerQuartile);
        if (this.lowValue < this.minValue) {
            this.lowValue = this.minValue;
        }
    }

    private void computeMeanMinMax(VectorModel vectorModel) {
        this.maxValue = -1.7976931348623157E308;
        this.minValue = Double.MAX_VALUE;
        double sum = 0.0;
        for (int i = 0; i < vectorModel.getRowCount(); ++i) {
            sum += vectorModel.getDouble(i);
            if (vectorModel.getDouble(i) > this.maxValue) {
                this.maxValue = vectorModel.getDouble(i);
            }
            if (!(vectorModel.getDouble(i) < this.minValue)) continue;
            this.minValue = vectorModel.getDouble(i);
        }
        this.meanValue = sum / (double)vectorModel.getRowCount();
    }

    private void computeStandardDeviation(VectorModel vectorModel) {
        double sum = 0.0;
        for (int i = 0; i < vectorModel.getRowCount(); ++i) {
            sum += (vectorModel.getDouble(i) - this.meanValue) * (vectorModel.getDouble(i) - this.meanValue);
        }
        this.standardDeviation = Math.sqrt(sum / (double)vectorModel.getRowCount());
    }

    public double getMeanValue() {
        return this.meanValue;
    }

    public double getMedianValue() {
        return this.medianValue;
    }

    public double getLowerQuartile() {
        return this.lowerQuartile;
    }

    public double getUpperQuartile() {
        return this.upperQuartile;
    }

    public double getStandardDeviation() {
        return this.standardDeviation;
    }

    public double getMaxValue() {
        return this.maxValue;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getLowValue() {
        return this.lowValue;
    }

    public double getHighValue() {
        return this.highValue;
    }
}

