/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.source;

import com.macrofocus.data.source.FileURLDataSource;
import com.macrofocus.data.source.TableSelector;
import com.macrofocus.data.table.RowMajorTableModel;
import com.macrofocus.util.logging.SwingLogging;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.swing.table.TableModel;

public class MicrosoftAccessDataSource
extends FileURLDataSource {
    static final String type = "MicrosoftAccessDataSource";

    public MicrosoftAccessDataSource(File file) {
        super(file);
    }

    public MicrosoftAccessDataSource(URL url) {
        super(url);
    }

    @Override
    public String getType() {
        return type;
    }

    @Override
    public TableModel loadTableModel(Component contentPane) throws IOException, SQLException {
        try {
            RowMajorTableModel tableModel;
            Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
            Connection conn = DriverManager.getConnection("jdbc:odbc:Driver={Microsoft Access Driver (*.mdb, *.accdb)};DBQ=" + this.file.getPath());
            ArrayList<String> tables = new ArrayList<String>();
            DatabaseMetaData meta = conn.getMetaData();
            ResultSet result = meta.getTables(null, null, null, new String[]{"TABLE", "VIEW"});
            while (result.next()) {
                String tableName = result.getString("TABLE_NAME");
                tables.add(tableName);
            }
            String table = null;
            switch (tables.size()) {
                case 0: {
                    table = null;
                    break;
                }
                case 1: {
                    table = (String)tables.get(0);
                    break;
                }
                default: {
                    TableSelector dialog = new TableSelector(tables);
                    dialog.setSize(300, 400);
                    dialog.setLocationRelativeTo(contentPane);
                    dialog.setVisible(true);
                    table = dialog.getSelected();
                }
            }
            if (table != null) {
                Statement st = conn.createStatement();
                ResultSet rs = st.executeQuery("SELECT * FROM `" + table + "`");
                tableModel = new RowMajorTableModel(null, rs);
                st.close();
            } else {
                tableModel = null;
            }
            conn.close();
            return tableModel;
        }
        catch (Exception e) {
            SwingLogging.getInstance().process(contentPane, (Throwable)e);
            return null;
        }
    }
}

