/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.table;

import com.macrofocus.data.table.AbstractTableModel;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.table.TableModel;

public class CrosstabTableModel
extends AbstractTableModel {
    private final TableModel tableModel;
    private final TreeMap<Object, Integer> names;
    private final TreeMap<Object, Integer> categories;
    private final List<Object> columnNames;
    private Object[][] array;
    private int nameColumn = 0;
    private int catColumn = 1;
    private int valueColumn = 2;

    public CrosstabTableModel(TableModel tableModel, int nameColumn, int catColumn, int valueColumn) {
        Object cat;
        Object name;
        int row;
        this.tableModel = tableModel;
        this.nameColumn = nameColumn;
        this.catColumn = catColumn;
        this.valueColumn = valueColumn;
        this.names = new TreeMap();
        this.categories = new TreeMap();
        for (row = 0; row < tableModel.getRowCount(); ++row) {
            name = tableModel.getValueAt(row, nameColumn);
            cat = tableModel.getValueAt(row, catColumn);
            if (name == null || cat == null) continue;
            this.categories.put(cat, null);
            this.names.put(name, null);
        }
        row = 0;
        for (Object value : this.names.keySet()) {
            this.names.put(value, row);
            ++row;
        }
        this.columnNames = new ArrayList<Object>();
        int column = 1;
        for (Object value : this.categories.keySet()) {
            this.categories.put(value, column);
            this.columnNames.add(value);
            ++column;
        }
        this.array = new Object[this.names.size()][1 + this.categories.size()];
        for (row = 0; row < tableModel.getRowCount(); ++row) {
            name = tableModel.getValueAt(row, nameColumn);
            cat = tableModel.getValueAt(row, catColumn);
            Object value = tableModel.getValueAt(row, valueColumn);
            if (name == null || cat == null) continue;
            int r = this.names.get(name);
            int c = this.categories.get(cat);
            this.array[r][0] = name;
            this.array[r][c] = value;
        }
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return this.tableModel.getColumnClass(this.nameColumn);
            }
        }
        return this.tableModel.getColumnClass(this.valueColumn);
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return this.tableModel.getColumnName(column);
            }
        }
        return this.columnNames.get(column - 1).toString();
    }

    @Override
    public int getRowCount() {
        return this.names.size();
    }

    @Override
    public int getColumnCount() {
        return 1 + this.categories.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        return this.array[rowIndex][columnIndex];
    }
}

