/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.table;

import com.macrofocus.common.logging.Logging;
import com.macrofocus.data.table.AbstractTableModel;
import com.macrofocus.util.file.filter.MicrosoftProjectDataInterchangeFileFilter;
import com.macrofocus.util.file.filter.MicrosoftProjectExchangeFileFilter;
import com.macrofocus.util.file.filter.MicrosoftProjectFileFilter;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import net.sf.mpxj.Duration;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.Task;
import net.sf.mpxj.mpp.MPPReader;
import net.sf.mpxj.mpx.MPXReader;
import net.sf.mpxj.mspdi.MSPDIReader;

public class ProjectTableModel
extends AbstractTableModel {
    private final List<Task> tasks;
    private final List<String[]> paths;

    public ProjectTableModel(InputStream is, FileFilter fileFilter) {
        ProjectFile mpx = null;
        if (fileFilter instanceof MicrosoftProjectExchangeFileFilter) {
            try {
                mpx = new MPXReader().read(is);
            }
            catch (MPXJException e1) {
                Logging.getInstance().process((Throwable)e1);
            }
        } else if (fileFilter instanceof MicrosoftProjectFileFilter) {
            try {
                mpx = new MPPReader().read(is);
            }
            catch (MPXJException e1) {
                Logging.getInstance().process((Throwable)e1);
            }
        } else if (fileFilter instanceof MicrosoftProjectDataInterchangeFileFilter) {
            try {
                mpx = new MSPDIReader().read(is);
            }
            catch (MPXJException e1) {
                Logging.getInstance().process((Throwable)e1);
            }
        }
        this.tasks = new ArrayList<Task>();
        this.paths = new ArrayList<String[]>();
        if (mpx != null) {
            ArrayList<Task> allTasks = new ArrayList<Task>();
            for (Task task : mpx.getTasks()) {
                allTasks.add(task);
            }
            for (Task task : allTasks) {
                if (task == null || task.getMilestone() || task.getChildTasks().size() > 0) continue;
                this.tasks.add(task);
            }
            for (Task task : this.tasks) {
                ArrayList<Task> path = new ArrayList<Task>();
                Task current = task;
                do {
                    path.add(current);
                } while ((current = current.getParentTask()) != null);
                String[] pathElement = new String[path.size()];
                for (int i = 0; i < pathElement.length; ++i) {
                    pathElement[i] = ((Task)path.get(path.size() - i - 1)).getName();
                }
                this.paths.add(pathElement);
            }
        }
    }

    @Override
    public int getRowCount() {
        return this.tasks.size();
    }

    @Override
    public int getColumnCount() {
        return 11;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Task task = this.tasks.get(rowIndex);
        if (task != null) {
            switch (columnIndex) {
                case 0: {
                    return this.paths.get(rowIndex);
                }
                case 1: {
                    return task.getName();
                }
                case 2: {
                    Duration duration = task.getDuration();
                    if (duration != null) {
                        return duration.getDuration();
                    }
                    return 0.0;
                }
                case 3: {
                    return task.getFreeSlack().getDuration();
                }
                case 4: {
                    return task.getTotalSlack().getDuration();
                }
                case 5: {
                    return task.getStart();
                }
                case 6: {
                    return task.getFinish();
                }
                case 7: {
                    return task.getPercentageWorkComplete();
                }
                case 8: {
                    return task.getCost();
                }
                case 9: {
                    Duration duration = task.getActualDuration();
                    if (duration != null) {
                        return duration.getDuration();
                    }
                    return 0.0;
                }
                case 10: {
                    return task.getPercentageWorkComplete();
                }
                case 11: {
                    return task.getPriority().getValue();
                }
            }
            return null;
        }
        return null;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Path";
            }
            case 1: {
                return "Name";
            }
            case 2: {
                return "Duration";
            }
            case 3: {
                return "Free Slack";
            }
            case 4: {
                return "Total Slack";
            }
            case 5: {
                return "Start";
            }
            case 6: {
                return "Finish";
            }
            case 7: {
                return "Percentage Work Complete";
            }
            case 8: {
                return "Cost";
            }
            case 9: {
                return "Actual Duration";
            }
            case 10: {
                return "Actual Cost";
            }
            case 11: {
                return "Priority";
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        switch (columnIndex) {
            case 0: {
                return String[].class;
            }
            case 1: {
                return String.class;
            }
            case 2: {
                return Double.class;
            }
            case 3: {
                return Double.class;
            }
            case 4: {
                return Double.class;
            }
            case 5: {
                return Date.class;
            }
            case 6: {
                return Date.class;
            }
            case 7: {
                return Number.class;
            }
            case 8: {
                return Double.class;
            }
            case 9: {
                return Double.class;
            }
            case 10: {
                return Double.class;
            }
            case 11: {
                return Integer.class;
            }
        }
        return null;
    }
}

