/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.type.timeseries;

import com.macrofocus.data.type.timeseries.NumericalTimeSeries;
import java.util.ArrayList;
import java.util.List;

public final class DoubleNumericalTimeSeries
implements NumericalTimeSeries<Double> {
    private final List<Long> times;
    private final List<Double> values;
    private Long min = Long.MAX_VALUE;
    private Long max = Long.MIN_VALUE;
    private Double minValue;
    private Double maxValue;

    public DoubleNumericalTimeSeries() {
        this.times = new ArrayList<Long>();
        this.values = new ArrayList<Double>();
    }

    @Override
    public Class<? extends Double> getType() {
        return Double.class;
    }

    @Override
    public long getTime(int index) {
        return this.times.get(index);
    }

    @Override
    public Double getValue(int index) {
        return this.values.get(index);
    }

    @Override
    public int getItemCount() {
        return this.times.size();
    }

    @Override
    public long getMinTime() {
        return this.min;
    }

    @Override
    public long getMaxTime() {
        return this.max;
    }

    public void addValue(Long time, Double value) {
        this.times.add(time);
        this.values.add(value);
        if (time < this.min) {
            this.min = time;
        }
        if (time > this.max) {
            this.max = time;
        }
        if (this.minValue == null || value < this.minValue) {
            this.minValue = value;
        }
        if (this.maxValue == null || value > this.maxValue) {
            this.maxValue = value;
        }
    }

    @Override
    public Double getMinValue() {
        return this.minValue;
    }

    @Override
    public Double getMaxValue() {
        return this.maxValue;
    }
}

