/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.data.type.timeseries;

import com.macrofocus.data.type.timeseries.NumericalTimeSeries;
import com.macrofocus.data.type.timeseries.SimpleNumericalTimeSeries;

public class MovingAverageTimeSeries
extends SimpleNumericalTimeSeries<Double> {
    public MovingAverageTimeSeries(NumericalTimeSeries<Number> timeSeries, int windowWidth) {
        super(Double.class);
        int i;
        int nl = windowWidth;
        int nr = windowWidth;
        double[] coeffs = new double[nl + nr + 1];
        for (i = 0; i < coeffs.length; ++i) {
            coeffs[i] = 1.0 / (double)coeffs.length;
        }
        for (i = nl; i < timeSeries.getItemCount() - nr; ++i) {
            double yValue = 0.0;
            for (int j = 0; j < nl + nr + 1; ++j) {
                Number previousObservation = (Number)timeSeries.getValue(i - nl + j);
                if (previousObservation == null) continue;
                yValue += coeffs[j] * previousObservation.doubleValue();
            }
            this.addValue(timeSeries.getTime(i), yValue);
        }
    }
}

