/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.file;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;

public class FileHelper {
    public static String getSuffix(File f) {
        if (f != null) {
            String s = f.getPath();
            String suffix = FileHelper.getSuffix(s);
            return suffix;
        }
        return null;
    }

    public static String getSuffix(String s) {
        Object suffix = null;
        int i = s.lastIndexOf(46);
        if (i > 0 && i < s.length() - 1) {
            suffix = s.substring(i + 1).toLowerCase();
            s = s.substring(0, i);
        }
        if (suffix != null && ((String)suffix).equals("gz") && (i = s.lastIndexOf(46)) > 0 && i < s.length() - 1) {
            suffix = s.substring(i + 1).toLowerCase() + "." + (String)suffix;
        }
        return suffix;
    }

    public static boolean hasSuffix(File file, String extension) {
        String name = file.getName();
        return name.endsWith("." + extension);
    }

    public static File replaceSuffix(File file, String suffix) {
        String name;
        File parent = file != null && file.getParentFile() != null ? file.getParentFile() : null;
        String string = name = file != null ? file.getName() : "Untitled";
        if (name.endsWith("." + suffix)) {
            return file;
        }
        int index = name.lastIndexOf(".");
        if (index > 0 && name.length() - index <= 5) {
            String newName = name.substring(0, index);
            return new File(parent, newName + "." + suffix);
        }
        return new File(parent, name + "." + suffix);
    }

    public static String addSuffix(String name, String suffix) {
        String string = name = name != null ? name : "Untitled";
        if (name.endsWith("." + suffix)) {
            return name;
        }
        return name + "." + suffix;
    }

    public static String replaceSuffix(String name, String suffix) {
        String string = name = name != null ? name : "Untitled";
        if (name.endsWith("." + suffix)) {
            return name;
        }
        int index = name.lastIndexOf(".");
        if (index > 0) {
            String newName = name.substring(0, index);
            return newName + "." + suffix;
        }
        return name + "." + suffix;
    }

    public static String removeSuffix(File file, String suffix) {
        String name = file.getName();
        if (name.endsWith("." + suffix)) {
            int index = name.lastIndexOf(".");
            String newName = name.substring(0, index);
            return newName;
        }
        return name;
    }

    public static String removeSuffix(File file) {
        String name = file.getName();
        return FileHelper.removeSuffix(name);
    }

    public static String removeSuffix(String name) {
        if (name.contains(".")) {
            int index = name.lastIndexOf(".");
            String newName = name.substring(0, index);
            return newName;
        }
        return name;
    }

    public static String getName(String path) {
        if (path.contains("\\") || path.contains("/")) {
            int index = Math.max(path.lastIndexOf("\\"), path.lastIndexOf("/"));
            String name = path.substring(index + 1);
            return name;
        }
        return path;
    }

    public static String getPath(String path) {
        if (path.contains("\\") || path.contains("/")) {
            int index = Math.max(path.lastIndexOf("\\"), path.lastIndexOf("/"));
            String name = path.substring(0, index);
            return name;
        }
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(InputStream in, OutputStream out) throws IOException {
        InputStream inputStream = in;
        synchronized (inputStream) {
            OutputStream outputStream = out;
            synchronized (outputStream) {
                int bytesRead;
                byte[] buffer = new byte[256];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
        }
    }

    public static String getRelativePath(String targetPath, String basePath, String pathSeparator) {
        int commonIndex;
        if (targetPath.toLowerCase().startsWith("file:/")) {
            targetPath = targetPath.substring(6);
            while (targetPath.startsWith("/")) {
                targetPath = targetPath.substring(1);
            }
        }
        if (basePath.toLowerCase().startsWith("file:/")) {
            basePath = basePath.substring(6);
            while (basePath.startsWith("/")) {
                basePath = basePath.substring(1);
            }
        }
        Object tempS = basePath;
        while (true) {
            File baseF;
            if ((baseF = new File((String)tempS)).exists() && baseF.isFile()) {
                basePath = baseF.getAbsolutePath();
                break;
            }
            if (!pathSeparator.equals("/") || ((String)tempS).startsWith("/")) break;
            tempS = "/" + (String)tempS;
        }
        tempS = targetPath;
        while (true) {
            File targetF;
            if ((targetF = new File((String)tempS)).exists() && targetF.isFile()) {
                targetPath = targetF.getAbsolutePath();
                break;
            }
            if (!pathSeparator.equals("/") || ((String)tempS).startsWith("/")) break;
            tempS = "/" + (String)tempS;
        }
        String normalizedTargetPath = FilenameUtils.normalizeNoEndSeparator((String)targetPath);
        String normalizedBasePath = FilenameUtils.normalizeNoEndSeparator((String)basePath);
        if (pathSeparator.equals("/")) {
            normalizedTargetPath = FilenameUtils.separatorsToUnix((String)normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToUnix((String)normalizedBasePath);
        } else if (pathSeparator.equals("\\")) {
            normalizedTargetPath = FilenameUtils.separatorsToWindows((String)normalizedTargetPath);
            normalizedBasePath = FilenameUtils.separatorsToWindows((String)normalizedBasePath);
        } else {
            throw new IllegalArgumentException("Unrecognised dir separator '" + pathSeparator + "'");
        }
        String[] base = normalizedBasePath.split(Pattern.quote(pathSeparator));
        String[] target = normalizedTargetPath.split(Pattern.quote(pathSeparator));
        StringBuffer common = new StringBuffer();
        for (commonIndex = 0; commonIndex < target.length && commonIndex < base.length && target[commonIndex].trim().equals(base[commonIndex].trim()); ++commonIndex) {
            common.append(target[commonIndex].trim() + pathSeparator);
        }
        if (commonIndex == 0) {
            File ff = new File(targetPath);
            if (ff.exists() && ff.isFile()) {
                return ff.getAbsolutePath();
            }
            throw new IllegalArgumentException("No common path element found for '" + normalizedTargetPath + "' and '" + normalizedBasePath + "'");
        }
        boolean baseIsFile = true;
        File baseResource = new File(normalizedBasePath);
        if (baseResource.exists()) {
            baseIsFile = baseResource.isFile();
        } else if (basePath.endsWith(pathSeparator)) {
            baseIsFile = false;
        }
        StringBuffer relative = new StringBuffer();
        if (base.length != commonIndex) {
            int numDirsUp = baseIsFile ? base.length - commonIndex - 1 : base.length - commonIndex;
            for (int i = 0; i < numDirsUp; ++i) {
                relative.append(".." + pathSeparator);
            }
        }
        if (common.length() >= normalizedTargetPath.length()) {
            return ".";
        }
        relative.append(normalizedTargetPath.substring(common.length()));
        return relative.toString();
    }
}

