/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.ole;

import com.macrofocus.common.logging.Logging;
import com.macrofocus.util.ole.BbdModel;
import com.macrofocus.util.ole.OleInputStream;
import com.macrofocus.util.ole.PpsBlockModel;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;

public class SimpleOleInputStream
extends OleInputStream {
    private PpsBlockModel ppsBlockModel;
    private BbdModel bbdModel;
    private byte[][] blocks;
    private int block;
    private int index;
    private int readCount;

    public SimpleOleInputStream(PpsBlockModel ppsBlockModel, BbdModel bbdModel, byte[][] blocks) {
        this.ppsBlockModel = ppsBlockModel;
        this.bbdModel = bbdModel;
        this.blocks = blocks;
        this.block = ppsBlockModel.getStartingBlock() + 1;
        this.index = 0;
        this.readCount = 0;
    }

    @Override
    public byte getByte() {
        byte value = this.blocks[this.block][this.index];
        this.next();
        return value;
    }

    @Override
    public int getUnsignedByte() {
        int intValue = this.getByte();
        if (intValue < 0) {
            intValue += 256;
        }
        return intValue;
    }

    @Override
    public int getShort() {
        return this.getUnsignedByte() + (this.getUnsignedByte() << 8);
    }

    @Override
    public int getInteger() {
        return this.getUnsignedByte() + (this.getUnsignedByte() << 8) + (this.getUnsignedByte() << 16) + (this.getUnsignedByte() << 24);
    }

    @Override
    public double getDouble() {
        byte[] array = new byte[8];
        array[7] = this.getByte();
        array[6] = this.getByte();
        array[5] = this.getByte();
        array[4] = this.getByte();
        array[3] = this.getByte();
        array[2] = this.getByte();
        array[1] = this.getByte();
        array[0] = this.getByte();
        double d = 0.0;
        ByteArrayInputStream bytearrayinputstream = new ByteArrayInputStream(array);
        DataInputStream datainputstream = new DataInputStream(bytearrayinputstream);
        try {
            Double double1 = datainputstream.readDouble();
            d = double1;
        }
        catch (IOException ioexception) {
            System.out.println("io exception in byte to Double conversion" + String.valueOf(ioexception));
        }
        return d;
    }

    @Override
    public String getString(int grbit, int count) {
        if ((grbit & 1) == 1) {
            if ((grbit & 0xB) == 11) {
                int crun = this.getShort();
                int cchExtRst = this.getInteger();
                String string = this.getUnicodeString(count);
                String rgb = this.getString(count);
                String rgStrun = this.getString(crun * 8);
                String extRst = this.getString(cchExtRst);
                return string;
            }
            if ((grbit & 4) == 4) {
                int cchExtRst = this.getInteger();
                String string = this.getUnicodeString(count);
                String extRst = this.getString(cchExtRst);
                return string;
            }
            if ((grbit & 8) == 8) {
                int crun = this.getShort();
                String string = this.getUnicodeString(count);
                String rgStrun = this.getString(crun * 8);
                return string;
            }
            return this.getUnicodeString(count);
        }
        if ((grbit & 0xB) == 11) {
            int crun = this.getShort();
            int cchExtRst = this.getInteger();
            String string = this.getString(count);
            String rgb = this.getString(count);
            String rgStrun = this.getString(crun * 8);
            String extRst = this.getString(cchExtRst);
            return string;
        }
        if ((grbit & 4) == 4) {
            System.err.println("8 bits Extended");
            int cchExtRst = this.getInteger();
            String string = this.getString(count);
            String extRst = this.getString(cchExtRst);
            return string;
        }
        if ((grbit & 8) == 8) {
            int crun = this.getShort();
            String string = this.getString(count);
            String rgStrun = this.getString(crun * 8);
            return string;
        }
        String string = this.getString(count);
        return string;
    }

    @Override
    public String getString(int count) {
        byte[] chars = new byte[count];
        for (int j = 0; j < count; ++j) {
            chars[j] = this.getByte();
        }
        try {
            String string = new String(chars, "LATIN1");
            return string;
        }
        catch (UnsupportedEncodingException e) {
            Logging.getInstance().process((Throwable)e);
            return "";
        }
    }

    public String getUnicodeString(int count) {
        char[] chars = new char[count];
        for (int j = 0; j < count; ++j) {
            chars[j] = (char)(this.getUnsignedByte() + (this.getUnsignedByte() << 8));
        }
        return new String(chars);
    }

    @Override
    public String getString() {
        int count = this.getShort();
        int grbit = this.getUnsignedByte();
        char[] chars = new char[count];
        String string = "";
        if ((grbit & 1) == 1) {
            for (int j = 0; j < count; ++j) {
                chars[j] = (char)(this.getUnsignedByte() + (this.getUnsignedByte() << 8));
            }
            string = new String(chars);
        } else {
            for (int j = 0; j < count; ++j) {
                chars[j] = (char)this.getByte();
            }
            string = new String(chars);
        }
        return string;
    }

    @Override
    public int getByteCount() {
        return this.ppsBlockModel.getSize();
    }

    @Override
    public int available() {
        return this.getByteCount() - this.readCount;
    }

    @Override
    public int getReadCount() {
        return this.readCount;
    }

    private void next() {
        ++this.index;
        if (this.index >= 512) {
            this.index = 0;
            this.block = this.bbdModel.getNextBlockIndex(this.block - 1) + 1;
        }
        ++this.readCount;
    }
}

