/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.molap.exporter.parquet;

import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.exporter.DataFrameExporter;
import com.macrofocus.molap.exporter.parquet.DataFrameParquetWriter;
import com.macrofocus.molap.exporter.parquet.ParquetOutputFile;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.util.HadoopOutputFile;
import org.apache.parquet.io.OutputFile;

public class ParquetDataFrameExporter
extends DataFrameExporter {
    public static <R, C, V> void exportParquet(DataFrame<R, C, V> df, File file) throws IOException {
        ParquetDataFrameExporter.exportParquetUsingOutputFile(df, (OutputFile)HadoopOutputFile.fromPath((Path)new Path(file.toString()), (Configuration)new Configuration()));
    }

    public static <R, C, V> void exportParquet(DataFrame<R, C, V> df, OutputStream file) throws IOException {
        ParquetDataFrameExporter.exportParquetUsingOutputFile(df, new ParquetOutputFile(file));
    }

    private static <R, C, V> void exportParquetUsingOutputFile(DataFrame<R, C, V> df, OutputFile file) throws IOException {
        CompressionCodecName compressionCodecName = CompressionCodecName.UNCOMPRESSED;
        int pageSize = 65536;
        ParquetWriter parquetWriter = ((DataFrameParquetWriter.Builder)((DataFrameParquetWriter.Builder)((DataFrameParquetWriter.Builder)DataFrameParquetWriter.builder(file).withSchema(df).withCompressionCodec(compressionCodecName)).withPageSize(pageSize)).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).build();
        for (Object row : df.rows()) {
            parquetWriter.write(row);
        }
        parquetWriter.close();
    }
}

