/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot;

import com.macrofocus.cartoplot.AbstractCartoPlotModel;
import com.macrofocus.cartoplot.axis.AbstractAxisModel;
import com.macrofocus.cartoplot.axis.AxisModel;
import com.macrofocus.cartoplot.georeferencing.GeoReferencingService;
import com.macrofocus.cartoplot.georeferencing.GeoReferencingServiceListener;
import com.macrofocus.coloring.MutableColoring;
import com.macrofocus.colormap.ColorMapFactory;
import com.macrofocus.colormapping.MutableColorMapping;
import com.macrofocus.colormapping.implementation.SimpleColorMapping;
import com.macrofocus.common.properties.MutableProperties;
import com.macrofocus.common.properties.MutableProperty;
import com.macrofocus.common.properties.SimpleProperties;
import com.macrofocus.common.selection.MutableSelection;
import com.macrofocus.common.selection.MutableSingleSelection;
import com.macrofocus.common.selection.SingleSelection;
import com.macrofocus.filter.Filter;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.visual.SimpleVisual;
import com.macrofocus.visual.SimpleVisualObjects;
import com.macrofocus.visual.Visual;
import com.macrofocus.visual.VisualObjects;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;

public class DefaultCartoPlotModel<Color, R, C>
extends AbstractCartoPlotModel<Color, R, C>
implements VisualObjects<R> {
    private DataFrame<R, C, ?> dataFrame;
    private MutableProperties properties = new SimpleProperties();
    private final MutableProperty<Boolean> fillSelected = this.properties.createProperty((Object)"fillSelected", (Object)Boolean.TRUE);
    private final Visual<Color, R, C> visual;
    private AxisModel xAxisModel;
    private AxisModel yAxisModel;
    private double minX = -180.0;
    private double minY = -85.0511;
    private double maxX = 180.0;
    private double maxY = 85.0511;
    private GeoReferencingService geoReferencingService;
    private GeoReferencingServiceListener geoReferencingServiceListener = new GeoReferencingServiceListener(){

        @Override
        public void geoReferencingServiceChanged() {
            DefaultCartoPlotModel.this.updateMinMax();
            DefaultCartoPlotModel.this.firedScatterPlotChanged();
        }
    };

    public <Value> DefaultCartoPlotModel(DataFrame<R, C, Value> dataFrame, ColorMapFactory colorMapFactory, GeoReferencingService geoReferencingService) {
        this(dataFrame, (Visual<Color, R, C>)new SimpleVisual((VisualObjects)new SimpleVisualObjects(dataFrame), (MutableColorMapping)new SimpleColorMapping(colorMapFactory, dataFrame)), geoReferencingService);
    }

    public <Value> DefaultCartoPlotModel(DataFrame<R, C, Value> dataFrame, Visual<Color, R, C> visual, final GeoReferencingService geoReferencingService) {
        this.dataFrame = dataFrame;
        this.visual = visual;
        this.setGeoReferencingService(geoReferencingService);
        this.xAxisModel = new MapAxisModel(){

            @Override
            public String getName() {
                return "X";
            }

            @Override
            public double getValue(int row) {
                return geoReferencingService.getGeometry(DefaultCartoPlotModel.this.getObject(row)).getCentroid().getX();
            }

            @Override
            public double getMinimum() {
                return DefaultCartoPlotModel.this.minX;
            }

            @Override
            public double getMaximum() {
                return DefaultCartoPlotModel.this.maxX;
            }

            @Override
            public void setMinimum(double min) {
                DefaultCartoPlotModel.this.minX = min;
            }

            @Override
            public void setMaximum(double max) {
                DefaultCartoPlotModel.this.maxX = max;
            }
        };
        this.yAxisModel = new MapAxisModel(){

            @Override
            public String getName() {
                return "Y";
            }

            @Override
            public double getValue(int row) {
                return geoReferencingService.getGeometry(DefaultCartoPlotModel.this.getObject(row)).getCentroid().getY();
            }

            @Override
            public double getMinimum() {
                return DefaultCartoPlotModel.this.minY;
            }

            @Override
            public double getMaximum() {
                return DefaultCartoPlotModel.this.maxY;
            }

            @Override
            public void setMinimum(double min) {
                DefaultCartoPlotModel.this.minY = min;
            }

            @Override
            public void setMaximum(double max) {
                DefaultCartoPlotModel.this.maxY = max;
            }
        };
    }

    @Override
    public MutableProperty<Boolean> getFillSelected() {
        return this.fillSelected;
    }

    @Override
    public GeoReferencingService getGeoReferencingService() {
        return this.geoReferencingService;
    }

    @Override
    public void setGeoReferencingService(GeoReferencingService geoReferencingService) {
        if (this.geoReferencingService != geoReferencingService) {
            if (this.geoReferencingService != null) {
                this.geoReferencingService.removeGeoReferencingServiceListener(this.geoReferencingServiceListener);
            }
            this.geoReferencingService = geoReferencingService;
            this.updateMinMax();
            geoReferencingService.addGeoReferencingServiceListener(this.geoReferencingServiceListener);
            this.firedScatterPlotChanged();
        }
    }

    @Override
    public int getObjectCount() {
        return this.dataFrame != null ? this.dataFrame.getRowCount() : 0;
    }

    @Override
    public Visual<Color, R, C> getVisual() {
        return this.visual;
    }

    @Override
    public MutableSingleSelection<R> getProbing() {
        return this.visual.getProbing();
    }

    @Override
    public MutableSelection<R> getSelection() {
        return this.visual.getSelection();
    }

    @Override
    public Filter<R> getFilter() {
        return this.visual.getFilter();
    }

    @Override
    public MutableColorMapping<Color, R, ?> getColorMapping() {
        return this.visual.getColorMapping();
    }

    @Override
    public MutableColoring<Color, R> getColoring() {
        return this.visual.getColoring();
    }

    @Override
    public R getObject(int index) {
        return (R)this.dataFrame.getRowKey(index);
    }

    @Override
    public DataFrame getDataFrame() {
        return this.dataFrame;
    }

    @Override
    public AxisModel getXAxisModel() {
        return this.xAxisModel;
    }

    @Override
    public AxisModel getYAxisModel() {
        return this.yAxisModel;
    }

    @Override
    public boolean isPointGeometry() {
        return this.getGeoReferencingService().isValid() && this.getGeoReferencingService().isPointGeometry();
    }

    @Override
    public Geometry getGeometry(R row) {
        return this.geoReferencingService.getGeometry(row);
    }

    private void updateMinMax() {
        double minX = Double.MAX_VALUE;
        double minY = Double.MAX_VALUE;
        double maxX = -1.7976931348623157E308;
        double maxY = -1.7976931348623157E308;
        for (int i = 0; i < this.getObjectCount(); ++i) {
            Geometry geometry = this.geoReferencingService.getGeometry(this.getObject(i));
            if (geometry == null) continue;
            Envelope envelope = geometry.getEnvelopeInternal();
            minX = Math.min(minX, envelope.getMinX());
            maxX = Math.max(maxX, envelope.getMaxX());
            minY = Math.min(minY, envelope.getMinY());
            maxY = Math.max(maxY, envelope.getMaxY());
        }
        if (minX == Double.MAX_VALUE || minY == Double.MAX_VALUE) {
            minX = -180.0;
            maxX = 180.0;
            minY = -85.0511;
            maxY = 85.0511;
        } else {
            double marginX = (maxX - minX) * 0.05;
            double marginY = (maxY - minY) * 0.05;
            minX = Math.max(-180.0, minX - marginX);
            maxX = Math.min(180.0, maxX + marginX);
            minY = Math.max(-85.0511, minY - marginY);
            maxY = Math.min(85.0511, maxY + marginY);
        }
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
    }

    private abstract class MapAxisModel
    extends AbstractAxisModel<R> {
        private MapAxisModel() {
        }

        @Override
        public boolean isAvailable(int row) {
            return DefaultCartoPlotModel.this.geoReferencingService.getGeometry(DefaultCartoPlotModel.this.getObject(row)) != null;
        }

        @Override
        public int getRowCount() {
            return DefaultCartoPlotModel.this.dataFrame.getRowCount();
        }

        @Override
        public SingleSelection<R> getProbing() {
            return null;
        }

        @Override
        public int getColumn() {
            return 0;
        }
    }
}

