/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot;

import com.macrofocus.cartoplot.IShapeCollectionPathIterator;
import com.macrofocus.cartoplot.ShapeCollectionPathIterator;
import com.macrofocus.geom.AffineTransform;
import com.macrofocus.geom.GeneralPath;
import com.macrofocus.geom.PathIterator;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.geom.Shape;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.locationtech.jts.geom.Coordinate;

public class PolygonIShape
implements Shape {
    private final GeneralPath shell;
    private List<GeneralPath> holes = new ArrayList<GeneralPath>();

    public PolygonIShape() {
        this.shell = null;
        this.holes = null;
    }

    public PolygonIShape(Coordinate[] shellVertices, Collection<Coordinate[]> holeVerticesCollection) {
        this.shell = this.toPolygon(shellVertices);
        for (Coordinate[] holeVertices : holeVerticesCollection) {
            this.holes.add(this.toPolygon(holeVertices));
        }
    }

    public final GeneralPath toPolygon(Coordinate[] coordinates) {
        int numPoints = coordinates.length;
        GeneralPath shape = new GeneralPath(0, numPoints);
        PolygonPath pi = new PolygonPath(coordinates);
        shape.append((PathIterator)pi, false);
        return shape;
    }

    public Rectangle2D getBounds2D() {
        return this.shell.getBounds2D();
    }

    public boolean contains(double x, double y) {
        throw new UnsupportedOperationException("Method contains() not yet implemented.");
    }

    public boolean contains(Point2D p) {
        if (this.shell.contains(p)) {
            for (GeneralPath hole : this.holes) {
                if (!hole.contains(p)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public boolean intersects(double x, double y, double w, double h) {
        return this.shell.intersects(x, y, w, h);
    }

    public boolean intersects(Rectangle2D r) {
        return this.shell.intersects(r);
    }

    public boolean contains(double x, double y, double w, double h) {
        throw new UnsupportedOperationException("Method contains() not yet implemented.");
    }

    public boolean contains(Rectangle2D r) {
        throw new UnsupportedOperationException("Method contains() not yet implemented.");
    }

    public PathIterator getPathIterator() {
        ArrayList<GeneralPath> rings = new ArrayList<GeneralPath>();
        rings.add(this.shell);
        rings.addAll(this.holes);
        return new IShapeCollectionPathIterator(rings);
    }

    public PathIterator getFlattenPathIterator(double flatness) {
        return this.getPathIterator();
    }

    public PathIterator getPathIterator(AffineTransform at) {
        ArrayList<GeneralPath> rings = new ArrayList<GeneralPath>();
        rings.add(this.shell);
        rings.addAll(this.holes);
        return new ShapeCollectionPathIterator(rings, at);
    }

    class PolygonPath
    implements PathIterator {
        private int iterate;
        private final int numPoints;
        private final Coordinate[] points;

        public PolygonPath(Coordinate[] coordinates) {
            this.points = coordinates;
            this.numPoints = this.points.length;
            this.iterate = 0;
        }

        private int getSegType() {
            if (this.iterate == this.numPoints - 1) {
                return 4;
            }
            return this.iterate == 0 ? 0 : 1;
        }

        public int currentSegment(double[] coords) {
            coords[0] = this.points[this.iterate].getX();
            coords[1] = this.points[this.iterate].getY();
            return this.getSegType();
        }

        public int currentSegment(float[] coords) {
            coords[0] = (float)this.points[this.iterate].getX();
            coords[1] = (float)this.points[this.iterate].getY();
            return this.getSegType();
        }

        public int getWindingRule() {
            return 0;
        }

        public boolean isDone() {
            return this.iterate >= this.numPoints;
        }

        public void next() {
            ++this.iterate;
        }
    }
}

