/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.button;

import com.macrofocus.button.ButtonEvent;
import com.macrofocus.button.ButtonListener;
import com.macrofocus.button.ButtonModel;
import com.macrofocus.button.ButtonView;
import com.macrofocus.color.ColorModel;
import com.macrofocus.color.RGBColorModel;
import com.macrofocus.helper.SwingHelper;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.util.java2d.RenderingHintsModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.UIManager;

public class BubbleLeftButtonView
extends ButtonView {
    private int screenWidth;
    private int screenHeight;
    private final ButtonModel buttonModel;
    private int minimumWidth;
    private int minimumHeight;
    private int maximumWidth;
    private Color backgroundColor;
    private Color textColor = Color.white;
    private Font font = new Font("Helvetica", 0, 12);
    private String label;
    private final String name;
    private JComponent bubble;
    private final PropertiesModel propertiesModel;
    private MouseListener mouseListener;
    private Color oldBackgroundColor;
    private final RenderingHintsModel renderingHintsModel;

    public BubbleLeftButtonView(final ButtonModel buttonModel, String name, String label, final PropertiesModel propertiesModel, boolean registerMouseListener, RenderingHintsModel renderingHintsModel) {
        this.buttonModel = buttonModel;
        this.name = name;
        this.label = label;
        this.propertiesModel = propertiesModel;
        this.renderingHintsModel = renderingHintsModel;
        this.updateProperties(propertiesModel);
        propertiesModel.addPropertiesListener(new PropertiesListener(){

            public void propertiesChanged(PropertiesEvent e) {
                BubbleLeftButtonView.this.updateProperties(propertiesModel);
                BubbleLeftButtonView.this.repaint();
            }
        });
        this.setOpaque(true);
        FontMetrics fontMetrics = this.getFontMetrics(this.font);
        this.minimumHeight = fontMetrics.getHeight() - fontMetrics.getLeading();
        this.minimumWidth = fontMetrics.stringWidth(label.substring(0, 1));
        this.maximumWidth = fontMetrics.stringWidth(label) + 2;
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                BubbleLeftButtonView.this.updateScreenValues();
                BubbleLeftButtonView.this.repaint();
            }
        });
        if (registerMouseListener) {
            this.addMouseListener(new MouseAdapter(){

                @Override
                public void mousePressed(MouseEvent e) {
                    buttonModel.setSelected(this);
                }
            });
        }
        buttonModel.addButtonListener(new ButtonListener(){

            @Override
            public void buttonSelected(ButtonEvent e) {
            }

            @Override
            public void buttonStateChanged(ButtonEvent e) {
            }

            @Override
            public void buttonEnabledChanged(ButtonEvent e) {
            }
        });
    }

    public void setLabel(Object source, String label) {
        this.label = label;
        this.repaint();
    }

    public void enableBubble(boolean isEnabled) {
        if (isEnabled && this.isShowing()) {
            this.setBackground(this.backgroundColor.brighter());
            Point scrnLoc = this.getLocationOnScreen();
            Dimension size = this.getSize();
            if (size.width < this.maximumWidth) {
                if (this.bubble == null) {
                    this.bubble = new BubbleLeftButtonView(this.buttonModel, null, this.label, this.propertiesModel, false, this.renderingHintsModel);
                    this.bubble.setBackground(this.getBackground());
                    JLayeredPane layeredPane = SwingHelper.getTopLayeredPane((Component)this);
                    layeredPane.add(this.bubble, JLayeredPane.POPUP_LAYER, 0);
                }
                Container parent = this.bubble.getParent();
                Point p = SwingHelper.convertScreenLocationToParent((Container)parent, (int)scrnLoc.x, (int)scrnLoc.y);
                Dimension d = this.bubble.getPreferredSize();
                if (p.x + d.width > parent.getWidth()) {
                    p.x = parent.getWidth() - d.width;
                }
                this.bubble.setLocation(p);
                this.bubble.setSize(d);
                this.bubble.setVisible(true);
            }
        } else {
            this.setBackground(this.backgroundColor);
            if (this.bubble != null && this.bubble.isVisible()) {
                this.bubble.setVisible(false);
                JLayeredPane layeredPane = SwingHelper.getTopLayeredPane((Component)this);
                layeredPane.remove(this.bubble);
                this.bubble = null;
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHints(this.renderingHintsModel.getRenderingHints());
        g.setFont(this.font);
        FontMetrics fontMetrics = g.getFontMetrics();
        g.setColor(this.textColor);
        int x = 1;
        g.drawString(this.label, x, fontMetrics.getMaxAscent());
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.minimumWidth, this.minimumHeight);
    }

    @Override
    public Dimension getPreferredSize() {
        return new Dimension(this.maximumWidth, this.minimumHeight);
    }

    public void setLabel(String label) {
        if (!this.label.equals(label)) {
            this.label = label;
            FontMetrics fontMetrics = this.getFontMetrics(this.font);
            this.minimumHeight = fontMetrics.getHeight() - fontMetrics.getLeading();
            this.minimumWidth = fontMetrics.stringWidth(label.substring(0, 1));
            this.maximumWidth = fontMetrics.stringWidth(label) + 2;
            this.invalidate();
            this.validate();
            this.repaint();
        }
    }

    protected void updateScreenValues() {
        Dimension size = this.getSize();
        this.screenWidth = size.width;
        this.screenHeight = size.height;
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        this.backgroundColor = ((ColorModel)propertiesModel.getValue(this.getClass(), this.name, "backgroundColor", (Object)new RGBColorModel(150, 180, 220))).getColor();
        this.setBackground(this.backgroundColor);
        this.textColor = ((ColorModel)propertiesModel.getValue(this.getClass(), this.name, "textColor", (Object)new RGBColorModel(0, 0, 0))).getColor();
        Font font = UIManager.getFont("TableHeader.font");
        if (font != null) {
            this.font = font;
        }
    }
}

