/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.button.plaf;

import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JButton;
import javax.swing.border.AbstractBorder;
import javax.swing.plaf.UIResource;

public class SimpleButtonBorder
extends AbstractBorder
implements UIResource {
    private Color backgroundColor;
    private Color lightColor;
    private Color darkColor;

    public SimpleButtonBorder(final PropertiesModel propertiesModel) {
        this.updateProperties(propertiesModel);
        propertiesModel.addPropertiesListener(new PropertiesListener(){

            public void propertiesChanged(PropertiesEvent e) {
                SimpleButtonBorder.this.updateProperties(propertiesModel);
            }
        });
    }

    public SimpleButtonBorder() {
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        boolean isPressed = false;
        boolean isDefault = false;
        this.backgroundColor = c.getBackground();
        if (this.backgroundColor != null) {
            this.lightColor = this.backgroundColor.brighter();
            this.darkColor = this.backgroundColor.darker();
        }
        if (c instanceof AbstractButton) {
            AbstractButton b = (AbstractButton)c;
            ButtonModel model = b.getModel();
            boolean bl = isPressed = model.isPressed() && model.isArmed() || model.isSelected();
            if (c instanceof JButton) {
                isDefault = ((JButton)c).isDefaultButton();
            }
        }
        if (isPressed) {
            g.setColor(this.darkColor);
            g.drawLine(0, 0, width - 2, 0);
            g.drawLine(0, 0, 0, height - 2);
            g.drawLine(0, height - 1, width - 1, height - 1);
            g.drawLine(width - 1, 0, width - 1, height - 1);
        } else {
            g.setColor(this.lightColor);
            g.drawLine(0, 0, width - 2, 0);
            g.drawLine(0, 0, 0, height - 2);
            g.setColor(this.darkColor);
            g.drawLine(1, height - 2, width - 2, height - 2);
            g.drawLine(width - 2, 1, width - 2, height - 2);
            g.setColor(Color.black);
            g.drawLine(0, height - 1, width - 1, height - 1);
            g.drawLine(width - 1, 0, width - 1, height - 1);
        }
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.getBorderInsets(c, new Insets(0, 0, 0, 0));
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        insets.top = 2;
        insets.right = 3;
        insets.bottom = 3;
        insets.left = 3;
        return insets;
    }

    private void updateProperties(PropertiesModel propertiesModel) {
    }
}

