/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.graphic;

import com.macrofocus.color.ColorModel;
import com.macrofocus.color.ColormapModel;
import com.macrofocus.color.SimpleColormapModel;
import com.macrofocus.graphic.AbstractDirectGraphicModel;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;

public final class AWTGraphicModel
extends AbstractDirectGraphicModel {
    private final int height;
    private final int width;
    private final ColormapModel colormapModel;
    private final Image memoryImage;
    private final Graphics g;
    private final Component component;

    public AWTGraphicModel(Component component, int[] r, int[] g, int[] b, int[] a, int width, int height) {
        this(component, (ColormapModel)new SimpleColormapModel(r, g, b, a), width, height);
    }

    public AWTGraphicModel(Component component, ColormapModel colormapModel, int width, int height) {
        this.width = width;
        this.height = height;
        this.component = component;
        this.colormapModel = colormapModel;
        this.memoryImage = component.createImage(width, height);
        this.g = this.memoryImage.getGraphics();
    }

    @Override
    public void drawPoint(int x, int y, ColorModel color) {
        this.g.setColor(color.getColor());
        this.g.drawLine(x, y, x, y);
    }

    @Override
    public void drawHorizontalLine(int x1, int x2, int y, ColorModel colorModel) {
        this.g.setColor(colorModel.getColor());
        this.g.drawLine(x1, y, x2 - x1, y);
    }

    @Override
    public void drawRect(int x1, int y1, int x2, int y2, ColorModel colorModel) {
        this.g.setColor(colorModel.getColor());
        this.g.drawRect(x1, y1, x2 - x1, y2 - y1);
    }

    @Override
    public void fillRect(int x1, int y1, int x2, int y2, ColorModel colorModel) {
        this.g.setColor(colorModel.getColor());
        this.g.fillRect(x1, y1, x2 - x1, y2 - y1);
    }

    @Override
    public void drawLine(int x1, int y1, int x2, int y2, ColorModel colorModel) {
        this.g.setColor(colorModel.getColor());
        this.g.drawLine(x1, y1, x2, y2);
    }

    @Override
    public void drawBitmap(byte[] bit_map, int bit_map_width, int bit_map_height, int x, int y) {
    }

    @Override
    public void clearImage(int color) {
        this.clearImage(this.colormapModel.getColorModel(color));
    }

    @Override
    public void clearImage(ColorModel color) {
        this.g.setColor(color.getColor());
        this.g.fillRect(0, 0, this.width, this.height);
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    public int getRed(int x, int y) {
        return 0;
    }

    public int getGreen(int x, int y) {
        return 0;
    }

    public int getBlue(int x, int y) {
        return 0;
    }

    public int getAlpha(int x, int y) {
        return 0;
    }

    @Override
    public ColormapModel getColormapModel() {
        return this.colormapModel;
    }

    @Override
    public Image getImage() {
        return this.memoryImage;
    }

    @Override
    public void newPixels() {
        this.component.imageUpdate(this.getImage(), 32, 0, 0, this.width, this.height);
    }

    @Override
    public void dispose() {
        this.memoryImage.flush();
    }
}

