/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.layer;

import com.macrofocus.layer.LayerHelper;
import com.macrofocus.layer.LayerView;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;

public class ContainerLayerView
extends Container
implements LayerView {
    private Insets insets = new Insets(0, 0, 0, 0);

    public ContainerLayerView(LayoutManager layoutManager) {
        this.setLayout(layoutManager);
    }

    public ContainerLayerView() {
    }

    @Override
    public String getName() {
        Object name = super.getName();
        if (name == null) {
            name = this.getClass().getName() + "@" + Integer.toHexString(this.hashCode());
        }
        return name;
    }

    @Override
    public Object getFullName() {
        return LayerHelper.getFullName(this);
    }

    @Override
    public LayerView getParentLayerView() {
        return LayerHelper.getParentLayerView(this);
    }

    @Override
    public Insets getInsets() {
        return this.insets;
    }

    @Override
    public void setInsets(Insets insets) {
        this.insets = insets;
    }

    @Override
    public void update(Graphics g) {
        LayerHelper.update(this, g);
    }

    @Override
    public Component getComponent() {
        return this;
    }

    public void repaintImmediately() {
        Graphics g = this.getGraphics();
        if (g != null) {
            try {
                this.paint(g);
            }
            finally {
                g.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaintImmediately(int x, int y, int width, int height) {
        Graphics g = this.getGraphics();
        if (g != null) {
            try {
                g.setClip(x, y, width, height);
                this.paint(g);
            }
            finally {
                g.dispose();
            }
        }
    }
}

