/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.soom.coordinator;

import com.macrofocus.soom.lens.coordinate.CoordinateAxisModel;
import com.macrofocus.soom.lens.zoom.BifocalLensZoom;
import com.macrofocus.soom.lens.zoom.CartesianFisheyeZoom;
import com.macrofocus.soom.lens.zoom.StandardViewportZoom;
import com.macrofocus.soom.lens.zoom.ZoomEvent;
import com.macrofocus.soom.lens.zoom.ZoomListener;
import com.macrofocus.soom.lens.zoom.ZoomStrategy;
import com.macrofocus.util.range.MBoundedRangeEvent;
import com.macrofocus.util.range.MBoundedRangeListener;
import com.macrofocus.util.range.MBoundedRangeModel;

public class AxisCoordinator {
    public AxisCoordinator(final MBoundedRangeModel rangeModel, final CoordinateAxisModel coordinateAxisModel) {
        rangeModel.addBoundedRangeListener(new MBoundedRangeListener(){

            public void boundedRangeChanged(MBoundedRangeEvent event) {
                if (event.getSource() != AxisCoordinator.this.getSelf()) {
                    double max_value;
                    double min_value;
                    double extent = rangeModel.getExtent();
                    double value = rangeModel.getValue();
                    if (coordinateAxisModel.getWorldCoordinatesInverted()) {
                        min_value = 1.0 - (value + extent);
                        max_value = 1.0 - value;
                    } else {
                        min_value = value;
                        max_value = value + extent;
                    }
                    ZoomStrategy zoomStrategy = coordinateAxisModel.getZoomStrategy();
                    if (zoomStrategy instanceof BifocalLensZoom) {
                        BifocalLensZoom bifocal_lens = (BifocalLensZoom)zoomStrategy;
                        bifocal_lens.setZoomWindowNormalized(AxisCoordinator.this.getSelf(), min_value, max_value);
                    } else if (zoomStrategy instanceof CartesianFisheyeZoom) {
                        CartesianFisheyeZoom cartesian_fisheye = (CartesianFisheyeZoom)zoomStrategy;
                        cartesian_fisheye.setZoomWindow(AxisCoordinator.this.getSelf(), min_value, max_value);
                    } else if (zoomStrategy instanceof StandardViewportZoom) {
                        StandardViewportZoom standard_zoom = (StandardViewportZoom)zoomStrategy;
                        standard_zoom.setMinMaxValues(AxisCoordinator.this.getSelf(), min_value, max_value);
                    }
                }
            }
        });
        coordinateAxisModel.getZoomStrategy().addZoomListener(new ZoomListener(){

            @Override
            public void zoomChanged(ZoomEvent event) {
                if (event.getSource() != AxisCoordinator.this.getSelf() && coordinateAxisModel.getZoomStrategy() instanceof BifocalLensZoom) {
                    double max_value;
                    double min_value;
                    BifocalLensZoom bifocalLensZoom = (BifocalLensZoom)coordinateAxisModel.getZoomStrategy();
                    double[] lens_boundaries = bifocalLensZoom.getLensBoundariesZoomed();
                    double x1 = lens_boundaries[0];
                    double x2 = lens_boundaries[1];
                    double extent = x2 - x1;
                    double value = x1;
                    if (coordinateAxisModel.getWorldCoordinatesInverted()) {
                        min_value = 1.0 - (value + extent);
                        max_value = 1.0 - value;
                    } else {
                        min_value = value;
                        max_value = value + extent;
                    }
                    rangeModel.setValue((Object)AxisCoordinator.this.getSelf(), min_value, max_value - min_value);
                }
            }
        });
    }

    private AxisCoordinator getSelf() {
        return this;
    }
}

