/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.timing;

import com.macrofocus.soom.lens.coordinate.CoordinateAxisModel;
import org.jdesktop.core.animation.timing.Animator;
import org.jdesktop.core.animation.timing.TimingTarget;

public class CoordinateTimingTarget
implements TimingTarget {
    private CoordinateAxisModel from;
    private CoordinateAxisModel to;

    public CoordinateTimingTarget(CoordinateAxisModel from, CoordinateAxisModel to) {
        this.from = from;
        this.to = to;
    }

    public void timingEvent(Animator source, double v) {
        if (this.from.getWorldMin() != this.to.getWorldMin() || this.from.getWorldMax() != this.to.getWorldMax()) {
            double min = CoordinateTimingTarget.inter(this.from.getWorldMin(), this.to.getWorldMin(), v);
            double max = CoordinateTimingTarget.inter(this.from.getWorldMax(), this.to.getWorldMax(), v);
            this.setWorld(min, max);
        }
    }

    private static double inter(double f, double t, double v) {
        return f + (t - f) * v;
    }

    public void begin(Animator source) {
        if (this.from.getWorldMin() != this.to.getWorldMin() || this.from.getWorldMax() != this.to.getWorldMax()) {
            // empty if block
        }
    }

    public void end(Animator source) {
        this.setWorld(this.to.getWorldMin(), this.to.getWorldMax());
    }

    public void repeat(Animator source) {
    }

    public void reverse(Animator source) {
    }

    private void setWorld(double min, double max) {
        this.from.setWorld(min, max);
    }
}

