/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.geometry;

import com.macrofocus.data.matrix.stat.MinMaxMatrixModel;
import com.macrofocus.util.geometry.Delaunay;
import com.macrofocus.util.geometry.PointModel;
import com.macrofocus.util.geometry.SegmentModel;
import com.macrofocus.util.geometry.TriangleModel;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.util.Random;
import javax.swing.JComponent;

public class DelaunayPanel
extends JComponent
implements Printable {
    private int highlight = -1;
    Random r = new Random();
    private Delaunay delaunay;
    private MinMaxMatrixModel minMaxMatrixModel;

    public DelaunayPanel(final MinMaxMatrixModel minMaxMatrixModel, final Delaunay delaunay) {
        this.minMaxMatrixModel = minMaxMatrixModel;
        this.delaunay = delaunay;
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                double firstDist = Double.MAX_VALUE;
                int firstIndex = -1;
                double x = (double)e.getX() * minMaxMatrixModel.getRange(0) / (double)DelaunayPanel.this.getSize().width + minMaxMatrixModel.getMin(0);
                double y = (double)e.getY() * minMaxMatrixModel.getRange(1) / (double)DelaunayPanel.this.getSize().height + minMaxMatrixModel.getMin(1);
                PointModel pointModel = new PointModel(x, y);
                System.err.println(pointModel);
                for (int i = 0; i < delaunay.canvas.getShapeCount(0); ++i) {
                    double dist = pointModel.distance2((PointModel)delaunay.canvas.getShape(0, i));
                    if (!(dist <= firstDist)) continue;
                    firstDist = dist;
                    firstIndex = i;
                }
                DelaunayPanel.this.setHighlight(firstIndex);
            }
        });
    }

    private void setHighlight(int index) {
        this.highlight = index;
        this.repaint();
    }

    @Override
    protected void paintComponent(Graphics g) {
        int i;
        super.paintComponent(g);
        Dimension d = this.getSize();
        Graphics2D g2 = (Graphics2D)g;
        AffineTransform tx = new AffineTransform();
        tx.scale((double)d.width / this.minMaxMatrixModel.getRange(0), (double)d.height / this.minMaxMatrixModel.getRange(1));
        tx.translate(-this.minMaxMatrixModel.getMin(0), -this.minMaxMatrixModel.getMin(1));
        g2.transform(tx);
        g2.setColor(Color.red);
        g2.setStroke(new BasicStroke(1.0E-4f));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.black);
        g2.setStroke(new BasicStroke(1.0E-4f));
        for (i = 0; i < this.delaunay.canvas.getShapeCount(0); ++i) {
            PointModel p = (PointModel)this.delaunay.canvas.getShape(0, i);
            for (int j = 0; j < p.getVoronoiCount(); ++j) {
                this.paintSegment(g2, p.getVoronoi(j));
            }
        }
        if (this.highlight != -1) {
            g2.setColor(Color.red);
            PointModel p = (PointModel)this.delaunay.canvas.getShape(0, this.highlight);
            for (int j = 0; j < p.getVoronoiCount(); ++j) {
                this.paintSegment(g2, p.getVoronoi(j));
            }
        }
        g2.setStroke(new BasicStroke(1.0f));
        g2.setColor(Color.blue);
        for (i = 0; i < this.delaunay.canvas.getShapeCount(0); ++i) {
            PointModel p = (PointModel)this.delaunay.canvas.getShape(0, i);
            Ellipse2D.Double rec = new Ellipse2D.Double(p.x - 0.05, p.y - 0.05, 0.05, 0.05);
            g2.fill(rec);
        }
    }

    @Override
    public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) throws PrinterException {
        if (pageIndex != 0) {
            return 1;
        }
        this.paintComponent(graphics);
        return 0;
    }

    private void paintSegment(Graphics2D g2, SegmentModel segmentModel) {
        Line2D.Double line = new Line2D.Double(segmentModel.a.x, segmentModel.a.y, segmentModel.b.x, segmentModel.b.y);
        g2.draw(line);
    }

    private void paintTriangle(Graphics2D g2, TriangleModel triangleModel) {
        GeneralPath gp = new GeneralPath();
        gp.moveTo((float)triangleModel.getA().x, (float)triangleModel.getA().y);
        gp.lineTo((float)triangleModel.getB().x, (float)triangleModel.getB().y);
        gp.lineTo((float)triangleModel.getC().x, (float)triangleModel.getC().y);
        gp.lineTo((float)triangleModel.getA().x, (float)triangleModel.getA().y);
        gp.closePath();
        g2.fill(gp);
    }

    private void paintPoint(Graphics2D g2, PointModel pointModel) {
        Rectangle2D.Double rec = new Rectangle2D.Double(pointModel.x, pointModel.y, 0.2, 0.2);
        g2.fill(rec);
    }

    private void paintVoronoi(Graphics2D g2, PointModel pointModel) {
        GeneralPath gp = new GeneralPath();
        if (pointModel.getVoronoiCount() > 0) {
            gp.moveTo((float)pointModel.getVoronoi((int)0).a.x, (float)pointModel.getVoronoi((int)0).a.y);
            gp.lineTo((float)pointModel.getVoronoi((int)0).b.x, (float)pointModel.getVoronoi((int)0).b.y);
            for (int j = 1; j < pointModel.getVoronoiCount(); ++j) {
                gp.lineTo((float)pointModel.getVoronoi((int)j).a.x, (float)pointModel.getVoronoi((int)j).a.y);
                gp.lineTo((float)pointModel.getVoronoi((int)j).b.x, (float)pointModel.getVoronoi((int)j).b.y);
            }
        }
        gp.closePath();
        g2.fill(gp);
    }
}

