/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.help;

import java.awt.Desktop;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;

public class OpenBrowserAction
extends AbstractAction {
    private URL url;
    private static final String osName = System.getProperty("os.name").toLowerCase();
    private static final boolean linux = osName.startsWith("linux");
    private static final boolean macosx = osName.startsWith("mac os x");
    private static final boolean win95 = osName.equals("windows 95");
    private static final boolean winAny = osName.startsWith("windows");

    public OpenBrowserAction(String url) throws MalformedURLException {
        this.setUrl(new URL(url));
    }

    public OpenBrowserAction(URL url) {
        this.setUrl(url);
    }

    public URL getUrl() {
        return this.url;
    }

    public void setUrl(URL url) {
        this.url = url;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (Desktop.isDesktopSupported() && Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                Desktop.getDesktop().browse(this.url.toURI());
            } else if (this.isApplet()) {
                this.openApplet(this.url);
            } else if (this.isWebStart()) {
                this.openWebstart(this.url);
            } else if (macosx) {
                OpenBrowserAction.openMacOSX(this.url);
            } else if (linux) {
                this.openLinux(this.url);
            } else if (win95) {
                this.openWin95(this.url);
            } else if (winAny) {
                this.openWindows(this.url);
            } else {
                this.openOther(this.url);
            }
        }
        catch (Throwable thr) {
            this.handleError(thr);
        }
    }

    protected void handleError(Throwable thr) {
        System.err.println(thr.getMessage());
        thr.printStackTrace(System.err);
    }

    private static void openMacOSX(URL url) throws IOException {
        try {
            Class<?> fileMgr = Class.forName("com.apple.eio.FileManager");
            Method openURL = fileMgr.getDeclaredMethod("openURL", String.class);
            openURL.invoke(null, url.toString());
        }
        catch (Throwable thr) {
            thr.printStackTrace();
            Runtime.getRuntime().exec(new String[]{"open", url.toString()});
        }
    }

    private void openLinux(URL url) throws Exception {
        try {
            Runtime.getRuntime().exec(new String[]{"./xdg-open", url.toString()});
        }
        catch (Throwable thr) {
            String[] browsers = new String[]{"firefox", "opera", "konqueror", "epiphany", "mozilla", "netscape"};
            String browser = null;
            for (int count = 0; count < browsers.length && browser == null; ++count) {
                if (Runtime.getRuntime().exec(new String[]{"which", browsers[count]}).waitFor() != 0) continue;
                browser = browsers[count];
            }
            if (browser == null) {
                throw new Exception("Could not find web browser");
            }
            Runtime.getRuntime().exec(new String[]{browser, url.toString()});
        }
    }

    private void openWin95(URL url) throws IOException {
        Runtime.getRuntime().exec(new String[]{"command.com", "/C", "start", url.toString()});
    }

    private void openWindows(URL url) throws IOException {
        Runtime.getRuntime().exec(new String[]{"cmd.exe", "/C", "start", url.toString()});
    }

    private void openOther(URL url) throws IOException {
        Runtime.getRuntime().exec(new String[]{"open", url.toString()});
    }

    private boolean isWebStart() {
        try {
            Class<?> svcManager = Class.forName("jnlp.ServiceManager");
            Method lookup = svcManager.getDeclaredMethod("lookup", String.class);
            lookup.invoke(null, "jnlp.BasicService");
            return true;
        }
        catch (Throwable thr) {
            return false;
        }
    }

    private void openWebstart(URL url) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> svcManager = Class.forName("javax.jnlp.ServiceManager");
        Method lookup = svcManager.getDeclaredMethod("lookup", String.class);
        Object basicSvcInst = lookup.invoke(null, "javax.jnlp.BasicService");
        Class<?> basicSvc = Class.forName("javax.jnlp.BasicService");
        Method showDocument = basicSvc.getDeclaredMethod("showDocument", URL.class);
        showDocument.invoke(basicSvcInst, url);
    }

    private boolean isApplet() {
        return false;
    }

    private void openApplet(URL url) {
        throw new UnsupportedOperationException("Not yet implemented");
    }
}

