/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.java2d;

import com.macrofocus.util.java2d.RenderingHintsModel;
import java.awt.RenderingHints;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JMenu;
import javax.swing.JRadioButtonMenuItem;

public class RenderingHintsMenu
extends JMenu {
    private RenderingHintsModel renderingHintsModel;

    public RenderingHintsMenu(RenderingHintsModel renderingHintsModel) {
        super("Rendering Hints");
        this.renderingHintsModel = renderingHintsModel;
        Object[] rendering = new Object[]{RenderingHints.VALUE_RENDER_DEFAULT, RenderingHints.VALUE_RENDER_SPEED, RenderingHints.VALUE_RENDER_QUALITY};
        this.addSubMenu(RenderingHints.KEY_RENDERING, rendering);
        Object[] antiAlias = new Object[]{RenderingHints.VALUE_ANTIALIAS_DEFAULT, RenderingHints.VALUE_ANTIALIAS_ON, RenderingHints.VALUE_ANTIALIAS_OFF};
        this.addSubMenu(RenderingHints.KEY_ANTIALIASING, antiAlias);
        Object[] textAntiAlias = new Object[]{RenderingHints.VALUE_TEXT_ANTIALIAS_DEFAULT, RenderingHints.VALUE_TEXT_ANTIALIAS_ON, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF};
        this.addSubMenu(RenderingHints.KEY_TEXT_ANTIALIASING, textAntiAlias);
        Object[] frationalMetrics = new Object[]{RenderingHints.VALUE_FRACTIONALMETRICS_DEFAULT, RenderingHints.VALUE_FRACTIONALMETRICS_ON, RenderingHints.VALUE_FRACTIONALMETRICS_OFF};
        this.addSubMenu(RenderingHints.KEY_FRACTIONALMETRICS, frationalMetrics);
        Object[] dithering = new Object[]{RenderingHints.VALUE_DITHER_DEFAULT, RenderingHints.VALUE_DITHER_ENABLE, RenderingHints.VALUE_DITHER_DISABLE};
        this.addSubMenu(RenderingHints.KEY_DITHERING, dithering);
        Object[] interpolation = new Object[]{RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR, RenderingHints.VALUE_INTERPOLATION_BILINEAR, RenderingHints.VALUE_INTERPOLATION_BICUBIC};
        this.addSubMenu(RenderingHints.KEY_INTERPOLATION, interpolation);
        Object[] alphaInterpolation = new Object[]{RenderingHints.VALUE_ALPHA_INTERPOLATION_DEFAULT, RenderingHints.VALUE_ALPHA_INTERPOLATION_SPEED, RenderingHints.VALUE_ALPHA_INTERPOLATION_QUALITY};
        this.addSubMenu(RenderingHints.KEY_ALPHA_INTERPOLATION, alphaInterpolation);
        Object[] colorRendering = new Object[]{RenderingHints.VALUE_COLOR_RENDER_DEFAULT, RenderingHints.VALUE_COLOR_RENDER_SPEED, RenderingHints.VALUE_COLOR_RENDER_QUALITY};
        this.addSubMenu(RenderingHints.KEY_COLOR_RENDERING, colorRendering);
        Object[] strokeControl = new Object[]{RenderingHints.VALUE_STROKE_DEFAULT, RenderingHints.VALUE_STROKE_NORMALIZE, RenderingHints.VALUE_STROKE_PURE};
        this.addSubMenu(RenderingHints.KEY_STROKE_CONTROL, strokeControl);
    }

    private void addSubMenu(final RenderingHints.Key key, final Object[] values) {
        JMenu menu = new JMenu(key.toString());
        JRadioButtonMenuItem[] menuItems = new JRadioButtonMenuItem[values.length];
        ButtonGroup buttonGroup = new ButtonGroup();
        for (int i = 0; i < values.length; ++i) {
            menuItems[i] = new JRadioButtonMenuItem(values[i].toString());
            if (this.renderingHintsModel.getRenderingHints().containsKey(key)) {
                if (this.renderingHintsModel.getRenderingHints().get(key).equals(values[i])) {
                    menuItems[i].setSelected(true);
                }
            } else if (i == 0) {
                menuItems[i].setSelected(true);
            }
            buttonGroup.add(menuItems[i]);
            final int index = i;
            menuItems[i].addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        RenderingHintsMenu.this.renderingHintsModel.setRenderingHint(key, values[index]);
                    }
                }
            });
            menu.add(menuItems[i]);
        }
        this.add(menu);
    }
}

