/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing;

import com.macrofocus.util.swing.waitwithstyle.PerformanceInfiniteProgressPanel;
import java.awt.Graphics;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;

public class LazyPanel
extends JPanel {
    private final LayzyComponent layzyComponent;
    private JComponent component = null;
    private PerformanceInfiniteProgressPanel wait;
    private boolean started = false;

    public LazyPanel(LayzyComponent layzyComponent) {
        this.layzyComponent = layzyComponent;
        this.setLayout(new OverlayLayout(this));
        this.wait = new PerformanceInfiniteProgressPanel(false);
        this.add(this.wait);
        this.validate();
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        if (!this.started && this.component == null) {
            this.started = true;
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    LazyPanel.this.wait.start();
                }
            });
            SwingWorker worker = new SwingWorker(){

                protected Object doInBackground() throws Exception {
                    LazyPanel.this.layzyComponent.init();
                    return null;
                }

                @Override
                protected void done() {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            LazyPanel.this.component = LazyPanel.this.layzyComponent.create();
                            LazyPanel.this.wait.stop();
                            LazyPanel.this.remove(LazyPanel.this.wait);
                            LazyPanel.this.add(LazyPanel.this.component);
                            LazyPanel.this.revalidate();
                        }
                    });
                }
            };
            worker.execute();
        }
    }

    public static interface LayzyComponent {
        public void init();

        public JComponent create();
    }
}

