/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.action;

import com.macrofocus.application.ApplicationModel;
import com.macrofocus.helper.SwingHelper;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import com.macrofocus.util.swing.animation.FadeAwayTimer;
import com.macrofocus.util.swing.window.AboutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.JWindow;

public class AboutAction
extends AbstractAction {
    private ResourcesModel resourceModel;
    private String filename;
    private ApplicationModel applicationModel;
    private final JRootPane rootPane;
    private int versionY = 100;

    public AboutAction(ResourcesModel resourcesModel, String filename, ApplicationModel applicationModel, JRootPane rootPane) {
        this.rootPane = rootPane;
        this.resourceModel = resourcesModel;
        this.filename = filename;
        this.applicationModel = applicationModel;
        final PropertiesModel propertiesModel = resourcesModel.getPropertiesModel();
        this.updateProperties(propertiesModel);
        if (propertiesModel != null) {
            propertiesModel.addPropertiesListener(new PropertiesListener(){

                public void propertiesChanged(PropertiesEvent e) {
                    AboutAction.this.updateProperties(propertiesModel);
                }
            });
        }
        this.putValue("MnemonicKey", 65);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        final AboutPanel splashPanel = new AboutPanel(this.resourceModel, this.filename, this.applicationModel);
        splashPanel.setVersionY(this.versionY);
        if (this.rootPane != null) {
            this.rootPane.getLayeredPane().add(splashPanel, JLayeredPane.POPUP_LAYER, 0);
            SwingHelper.center((Container)this.rootPane.getLayeredPane(), (Component)splashPanel);
            splashPanel.setActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FadeAwayTimer timer = new FadeAwayTimer(0, 1000L, splashPanel);
                    timer.start();
                }
            });
        } else {
            final JWindow frame = new JWindow();
            frame.setBackground(new Color(0, 0, 0, 0));
            frame.setLayout(new BorderLayout());
            frame.add((Component)splashPanel, "Center");
            frame.setLocationRelativeTo(null);
            frame.pack();
            frame.setVisible(true);
            splashPanel.setActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    FadeAwayTimer timer = new FadeAwayTimer(0, 1000L, splashPanel, new Runnable(){

                        @Override
                        public void run() {
                            frame.dispose();
                        }
                    });
                    timer.start();
                }
            });
        }
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        String name = "About " + this.applicationModel.getName() + "...";
        if (propertiesModel != null && propertiesModel.isAvailable("action.about.label")) {
            name = String.valueOf(propertiesModel.getValue("action.about.label")) + " " + this.applicationModel.getName() + "...";
        }
        this.putValue("Name", name);
    }

    public void setApplicationModel(ApplicationModel applicationModel) {
        this.applicationModel = applicationModel;
    }

    public void setVersionY(int versionY) {
        this.versionY = versionY;
    }
}

