/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.action;

import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Icon;

public class ToggleAction
extends AbstractAction {
    public static final String STATE = "STATE";

    public ToggleAction(final String key, final PropertiesModel propertiesModel) {
        this.updateProperties(key, propertiesModel);
        propertiesModel.addPropertiesListener(new PropertiesListener(){

            public void propertiesChanged(PropertiesEvent e) {
                ToggleAction.this.updateProperties(key, propertiesModel);
            }
        });
    }

    public ToggleAction(final String key, boolean selected, final PropertiesModel propertiesModel) {
        this.updateProperties(key, propertiesModel);
        propertiesModel.addPropertiesListener(new PropertiesListener(){

            public void propertiesChanged(PropertiesEvent e) {
                ToggleAction.this.updateProperties(key, propertiesModel);
            }
        });
        this.setSelected(selected);
    }

    public ToggleAction(String name) {
        this(name, false);
    }

    public ToggleAction(String name, Icon icon) {
        this(name, icon, false);
    }

    public ToggleAction() {
        this(false);
    }

    public ToggleAction(String name, boolean selected) {
        super(name);
        this.setSelected(selected);
    }

    public ToggleAction(String name, Icon icon, boolean selected) {
        super(name, icon);
        this.setSelected(selected);
    }

    public ToggleAction(boolean selected) {
        this.setSelected(selected);
    }

    public boolean isSelected() {
        return this.getValue(STATE) == Boolean.TRUE;
    }

    public void setSelected(boolean state) {
        if (this.getValue(STATE) == null || this.getValue(STATE) != Boolean.valueOf(state)) {
            this.putValue(STATE, state ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    @Override
    public void actionPerformed(ActionEvent ev) {
        this.setSelected(!this.isSelected());
    }

    private void updateProperties(String key, PropertiesModel propertiesModel) {
        String name = "Unknown";
        if (propertiesModel.isAvailable(key)) {
            name = (String)propertiesModel.getValue(key);
        }
        this.putValue("Name", name);
        this.putValue("ShortDescription", name);
    }
}

