/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.animation;

import com.macrofocus.util.swing.Translucent;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;

public class FadeAwayTimer
extends Timer {
    public FadeAwayTimer(int delay, long duration, Translucent panel) {
        this(delay, duration, panel, null);
    }

    public FadeAwayTimer(int delay, final long duration, final Translucent panel, final Runnable endAction) {
        super(delay, new ActionListener(){
            private Timer fade;

            @Override
            public void actionPerformed(ActionEvent e) {
                this.fade = new Timer(30, new ActionListener(){
                    float startAlpha = 1.0f;
                    float endAlpha = 0.0f;
                    long startTime = System.currentTimeMillis();

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        long nowTime = System.currentTimeMillis();
                        long elapsedTime = nowTime - this.startTime;
                        final float alpha = this.startAlpha + (this.endAlpha - this.startAlpha) * (float)elapsedTime / (float)duration;
                        if (elapsedTime < duration) {
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    if (panel != null) {
                                        panel.setAlpha(alpha);
                                    }
                                }
                            };
                            if (SwingUtilities.isEventDispatchThread()) {
                                runnable.run();
                            } else {
                                SwingUtilities.invokeLater(runnable);
                            }
                        } else {
                            Runnable runnable = new Runnable(){

                                @Override
                                public void run() {
                                    if (panel != null) {
                                        panel.getComponent().setVisible(false);
                                        Container parent = panel.getComponent().getParent();
                                        if (parent != null) {
                                            parent.remove(panel.getComponent());
                                        }
                                        if (endAction != null) {
                                            endAction.run();
                                        }
                                    }
                                }
                            };
                            if (SwingUtilities.isEventDispatchThread()) {
                                runnable.run();
                            } else {
                                SwingUtilities.invokeLater(runnable);
                            }
                            this.stopFadding();
                        }
                    }
                });
                this.fade.setRepeats(true);
                this.fade.setCoalesce(true);
                this.fade.start();
            }

            public void stopFadding() {
                this.fade.setRepeats(false);
                this.fade.stop();
            }
        });
        this.setRepeats(false);
    }
}

