/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.dnd;

import com.macrofocus.util.swing.dnd.DragHandler;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public abstract class DropHandler
implements DropTargetListener {
    private int acceptedActions;
    private DropTarget dropTarget;
    private boolean active = true;
    static DropTarget currentDropTarget;
    private String lastAction;

    public DropHandler(Component c, int acceptedActions) {
        this.acceptedActions = acceptedActions;
        this.dropTarget = new DropTarget(c, acceptedActions, this, this.active);
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
        if (this.dropTarget != null) {
            this.dropTarget.setActive(active);
        }
    }

    protected int getDropAction(DropTargetEvent e) {
        int action;
        DropTargetEvent ev;
        int currentAction = 0;
        int sourceActions = 0;
        List<DataFlavor> flavors = Collections.EMPTY_LIST;
        int modifiers = this.getModifiers();
        if (e instanceof DropTargetDragEvent) {
            ev = (DropTargetDragEvent)e;
            currentAction = ((DropTargetDragEvent)ev).getDropAction();
            sourceActions = ((DropTargetDragEvent)ev).getSourceActions();
            flavors = ((DropTargetDragEvent)ev).getCurrentDataFlavorsAsList();
        } else if (e instanceof DropTargetDropEvent) {
            ev = (DropTargetDropEvent)e;
            currentAction = ((DropTargetDropEvent)ev).getDropAction();
            sourceActions = ((DropTargetDropEvent)ev).getSourceActions();
            flavors = ((DropTargetDropEvent)ev).getCurrentDataFlavorsAsList();
        }
        if ((currentAction & this.acceptedActions) == 0 && modifiers == 0) {
            currentAction = this.acceptedActions & sourceActions;
        } else if (modifiers != 0 && (action = currentAction & this.acceptedActions & sourceActions) != currentAction) {
            currentAction = action;
        }
        return this.isSupported(flavors) ? currentAction : 0;
    }

    protected int getModifiers() {
        return DragHandler.modifiers;
    }

    private void describe(String type, DropTargetEvent e) {
        Object msg = type;
        if (e instanceof DropTargetDragEvent) {
            DropTargetContext dtc = e.getDropTargetContext();
            DropTarget dt = dtc.getDropTarget();
            DropTargetDragEvent ev = (DropTargetDragEvent)e;
            msg = (String)msg + ": src=" + DragHandler.actionString(ev.getSourceActions()) + " tgt=" + DragHandler.actionString(dt.getDefaultActions()) + " act=" + DragHandler.actionString(ev.getDropAction());
        } else if (e instanceof DropTargetDropEvent) {
            DropTargetContext dtc = e.getDropTargetContext();
            DropTarget dt = dtc.getDropTarget();
            DropTargetDropEvent ev = (DropTargetDropEvent)e;
            msg = (String)msg + ": src=" + DragHandler.actionString(ev.getSourceActions()) + " tgt=" + DragHandler.actionString(dt.getDefaultActions()) + " act=" + DragHandler.actionString(ev.getDropAction());
        }
        if (!((String)msg).equals(this.lastAction)) {
            // empty if block
        }
    }

    @Override
    public void dragEnter(DropTargetDragEvent e) {
        currentDropTarget = this.dropTarget;
        this.describe("enter(tgt)", e);
        this.paintDropTarget(e, this.getDropAction(e));
    }

    @Override
    public void dragOver(DropTargetDragEvent e) {
        this.describe("over(tgt)", e);
        int action = this.getDropAction(e);
        if (action != 0) {
            e.acceptDrag(action);
        } else {
            e.rejectDrag();
        }
        this.paintDropTarget(e, action);
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        this.describe("exit(tgt)", e);
        this.paintDropTarget(e, 0);
        currentDropTarget = null;
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
        this.describe("change(tgt)", e);
        int action = this.getDropAction(e);
        if (action != 0) {
            e.acceptDrag(action);
        } else {
            e.rejectDrag();
        }
        this.paintDropTarget(e, action);
    }

    @Override
    public void drop(DropTargetDropEvent e) {
        this.describe("drop(tgt)", e);
        int action = this.getDropAction(e);
        if (action != 0 && this.canDrop(e, action)) {
            e.acceptDrop(action);
            try {
                Transferable t = e.getTransferable();
                DataFlavor[] flavors = t.getTransferDataFlavors();
                if (flavors.length != 0) {
                    this.drop(e, action);
                } else {
                    action = 0;
                }
            }
            catch (Exception ex) {
                action = 0;
            }
            e.dropComplete(action != 0);
        } else {
            e.rejectDrop();
        }
        this.paintDropTarget(e, 0);
    }

    protected abstract boolean isSupported(List var1);

    protected void paintDropTarget(DropTargetEvent e, int action) {
    }

    protected boolean canDrop(DropTargetDropEvent e, int action) {
        return true;
    }

    protected void drop(DropTargetDropEvent e, int action) throws UnsupportedFlavorException, IOException {
    }
}

