/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.export.format;

import com.macrofocus.util.file.filter.AbstractFileFilter;
import com.macrofocus.util.file.filter.GifFileFilter;
import com.macrofocus.util.file.filter.JpegFileFilter;
import com.macrofocus.util.file.filter.PngFileFilter;
import com.macrofocus.util.file.filter.TiffFileFilter;
import com.macrofocus.util.file.filter.WebPFileFilter;
import com.macrofocus.util.swing.export.format.AbstractGraphicsExportFormat;
import com.macrofocus.util.swing.export.format.ContentProvider;
import com.macrofocus.util.swing.export.format.DPI;
import com.macrofocus.util.swing.export.format.PNGFormatSettingsEditor;
import com.macrofocus.util.swing.print.ImageSelection;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOInvalidTreeException;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.FileImageOutputStream;

public abstract class AbstractRasterExportFormat
extends AbstractGraphicsExportFormat {
    protected static final PngFileFilter pngFileFilter = new PngFileFilter();
    protected static final JpegFileFilter jpgFileFilter = new JpegFileFilter();
    protected static final GifFileFilter gifFileFilter = new GifFileFilter();
    protected static final TiffFileFilter tiffFileFilter = new TiffFileFilter();
    protected static final WebPFileFilter webPFileFilter = new WebPFileFilter();
    private PNGFormatSettingsEditor editor;

    @Override
    public abstract AbstractFileFilter getFileFilter();

    @Override
    public boolean isValid() {
        return ImageIO.getImageWritersByFormatName(this.getFileFilter().getDefaultExtension()).hasNext();
    }

    @Override
    public void copy(ContentProvider<Component> contentProvider) {
        BufferedImage bufferedImage = this.createImage(contentProvider.getContent());
        ImageSelection.copyImageToClipboard(bufferedImage);
    }

    @Override
    public void save(ContentProvider<Component> contentProvider, File file) throws IOException {
        BufferedImage bufferedImage = this.createImage(contentProvider.getContent());
        this.write(bufferedImage, this.getFileFilter().getDefaultExtension(), this.getOutputDPI(), file);
    }

    protected void write(BufferedImage img, String format, float dpi, File outFile) throws IOException {
        ImageWriter writer = ImageIO.getImageWritersByFormatName(format).next();
        FileImageOutputStream fios = new FileImageOutputStream(outFile);
        writer.setOutput(fios);
        ImageWriteParam writeParam = this.createWriteParam(writer);
        IIOMetadata destMeta = this.createMetadata(writer, dpi, dpi, img, writeParam);
        writer.write(null, new IIOImage(img, null, destMeta), writeParam);
        writer.dispose();
        fios.close();
    }

    protected abstract IIOMetadata createMetadata(ImageWriter var1, float var2, float var3, RenderedImage var4, ImageWriteParam var5) throws IIOInvalidTreeException;

    protected abstract ImageWriteParam createWriteParam(ImageWriter var1);

    protected BufferedImage createImage(Component component) {
        double scale = this.getOutputDPI() / this.getScreenDPI();
        int width = (int)Math.floor((double)this.getExportWidth(component) * scale);
        int height = (int)Math.floor((double)this.getExportHeight(component) * scale);
        if (width > 0 && height > 0) {
            BufferedImage bufferedImage = new BufferedImage(width, height, 2);
            Graphics2D g = bufferedImage.createGraphics();
            g.scale(scale, scale);
            this.print(component, g);
            if (this.getFileFilter().equals((Object)jpgFileFilter) || this.getFileFilter().equals((Object)gifFileFilter)) {
                bufferedImage = AbstractRasterExportFormat.fillTransparentPixels(bufferedImage, component.getBackground());
            }
            bufferedImage.flush();
            g.dispose();
            return bufferedImage;
        }
        return null;
    }

    public static BufferedImage fillTransparentPixels(BufferedImage image, Color fillColor) {
        int w = image.getWidth();
        int h = image.getHeight();
        BufferedImage image2 = new BufferedImage(w, h, 1);
        Graphics2D g = image2.createGraphics();
        g.setColor(fillColor);
        g.fillRect(0, 0, w, h);
        g.drawRenderedImage(image, null);
        g.dispose();
        return image2;
    }

    protected PNGFormatSettingsEditor getSettingsEditor() {
        if (this.editor == null) {
            this.editor = new PNGFormatSettingsEditor();
        }
        return this.editor;
    }

    public float getScreenDPI() {
        return this.getSettingsEditor().getScreenDPI().getValue();
    }

    public float getOutputDPI() {
        return this.getSettingsEditor().getOutputDPI().getValue();
    }

    public void setScreenDPI(int dpi) {
        this.getSettingsEditor().setScreenDPI(new DPI(dpi));
    }

    public void setOutputDPI(float dpi) {
        this.getSettingsEditor().setOutputDPI(new DPI(dpi));
    }
}

