/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.export.format;

import com.macrofocus.util.file.filter.AbstractFileFilter;
import com.macrofocus.util.file.filter.SvgFileFilter;
import com.macrofocus.util.swing.export.format.AbstractGraphicsExportFormat;
import com.macrofocus.util.swing.export.format.ContentProvider;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import org.apache.batik.dom.GenericDOMImplementation;
import org.apache.batik.svggen.DefaultErrorHandler;
import org.apache.batik.svggen.DefaultExtensionHandler;
import org.apache.batik.svggen.DefaultStyleHandler;
import org.apache.batik.svggen.ErrorHandler;
import org.apache.batik.svggen.ExtensionHandler;
import org.apache.batik.svggen.ImageHandler;
import org.apache.batik.svggen.ImageHandlerBase64Encoder;
import org.apache.batik.svggen.SVGGeneratorContext;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.svggen.SVGIDGenerator;
import org.apache.batik.svggen.StyleHandler;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;

public class SVGExportFormat
extends AbstractGraphicsExportFormat {
    private boolean textAsShape = false;
    private boolean useCSS = true;
    private boolean embeddedFontsOn = false;

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public AbstractFileFilter getFileFilter() {
        return new SvgFileFilter();
    }

    @Override
    public Component getSettingsPanel() {
        return null;
    }

    public boolean isTextAsShape() {
        return this.textAsShape;
    }

    public void setTextAsShape(boolean textAsShape) {
        this.textAsShape = textAsShape;
    }

    public boolean isUseCSS() {
        return this.useCSS;
    }

    public void setUseCSS(boolean useCSS) {
        this.useCSS = useCSS;
    }

    public boolean isEmbeddedFontsOn() {
        return this.embeddedFontsOn;
    }

    public void setEmbeddedFontsOn(boolean embeddedFontsOn) {
        this.embeddedFontsOn = embeddedFontsOn;
    }

    @Override
    public void save(ContentProvider<Component> contentProvider, File file) throws IOException {
        FileOutputStream outputStream = new FileOutputStream(file);
        this.writeStream(contentProvider.getContent(), outputStream);
    }

    public void writeStream(Component component, OutputStream outputStream) throws UnsupportedEncodingException, IOException {
        OutputStreamWriter out = new OutputStreamWriter(outputStream, StandardCharsets.UTF_8);
        DOMImplementation domImpl = GenericDOMImplementation.getDOMImplementation();
        String svgNS = "http://www.w3.org/2000/svg";
        Document document = domImpl.createDocument("http://www.w3.org/2000/svg", "svg", null);
        MacrofocusSVGGeneratorContext svgGeneratorContext = new MacrofocusSVGGeneratorContext(document);
        svgGeneratorContext.setEmbeddedFontsOn(this.isEmbeddedFontsOn());
        SVGGraphics2D svgGenerator = new SVGGraphics2D((SVGGeneratorContext)svgGeneratorContext, this.isTextAsShape());
        svgGenerator.setSVGCanvasSize(new Dimension(this.getExportWidth(component), this.getExportHeight(component)));
        this.print(component, (Graphics)svgGenerator);
        svgGenerator.stream((Writer)out, this.isUseCSS());
    }

    public String toString() {
        return this.getFileFilter().getName();
    }

    public static class MacrofocusSVGGeneratorContext
    extends SVGGeneratorContext {
        public MacrofocusSVGGeneratorContext(Document document) {
            super(document);
            this.setIDGenerator(new SVGIDGenerator());
            this.setExtensionHandler((ExtensionHandler)new DefaultExtensionHandler());
            this.setImageHandler((ImageHandler)new ImageHandlerBase64Encoder());
            this.setStyleHandler((StyleHandler)new DefaultStyleHandler());
            this.setComment("Generated by Macrofocus");
            this.setErrorHandler((ErrorHandler)new DefaultErrorHandler());
        }
    }
}

