/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.print;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;

public class JComponentPrintable
implements Printable {
    private Component component;
    private boolean mainAspectRatio;

    public JComponentPrintable(Component component, boolean mainAspectRatio) {
        this.component = component;
        this.mainAspectRatio = mainAspectRatio;
    }

    @Override
    public int print(Graphics g, PageFormat pageFormat, int pageIndex) {
        if (pageIndex > 0) {
            return 1;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
        double xRatio = pageFormat.getImageableWidth() / (double)this.component.getWidth();
        double yRatio = pageFormat.getImageableHeight() / (double)this.component.getHeight();
        if (this.mainAspectRatio) {
            double ratio;
            xRatio = ratio = Math.min(xRatio, yRatio);
            yRatio = ratio;
        }
        g2.scale(xRatio, yRatio);
        this.component.printAll(g2);
        return 0;
    }
}

