/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.swing.waitwithstyle;

import com.macrofocus.helper.WeakActionListeners;
import com.macrofocus.util.swing.waitwithstyle.CancelableAdaptee;
import com.macrofocus.util.swing.waitwithstyle.InfiniteProgressAdapter;
import java.awt.Cursor;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;

public class CancelableProgessAdapter
implements InfiniteProgressAdapter {
    protected CancelableAdaptee progressPanel;
    protected JLabel textLabel;
    protected JButton cancelButton;
    protected JButton applicationDefaultButton;
    private JRootPane rootPane;
    private final WeakActionListeners actionListeners = new WeakActionListeners();

    public CancelableProgessAdapter(CancelableAdaptee progressPanel) {
        this.setAdaptee(progressPanel);
    }

    public void setAdaptee(CancelableAdaptee progressPanel) {
        this.progressPanel = progressPanel;
    }

    public void addCancelListener(ActionListener listener) {
        if (this.cancelButton == null) {
            this.cancelButton = this.createCancelButton();
        }
        if (this.cancelButton != null) {
            this.cancelButton.addActionListener(this.actionListeners.create(listener, (Object)this.cancelButton));
        }
    }

    public void removeCancelListener(ActionListener listener) {
        if (this.cancelButton != null) {
            this.cancelButton.removeActionListener(this.actionListeners.remove(listener));
        }
    }

    protected JButton createCancelButton() {
        if (this.progressPanel instanceof JComponent) {
            this.rootPane = ((JComponent)((Object)this.progressPanel)).getRootPane();
            if (this.rootPane != null) {
                this.rootPane.addPropertyChangeListener(new PropertyChangeListener(){

                    @Override
                    public void propertyChange(PropertyChangeEvent evt) {
                        JButton oldDefaultButton;
                        if ("defaultButton".equals(evt.getPropertyName()) && (oldDefaultButton = (JButton)evt.getOldValue()) != CancelableProgessAdapter.this.cancelButton) {
                            CancelableProgessAdapter.this.applicationDefaultButton = oldDefaultButton;
                        }
                    }
                });
            }
        }
        JButton button = new JButton("Cancel");
        button.setCursor(Cursor.getDefaultCursor());
        button.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CancelableProgessAdapter.this.progressPanel.stop();
                if (CancelableProgessAdapter.this.rootPane != null) {
                    if (CancelableProgessAdapter.this.applicationDefaultButton != null) {
                        CancelableProgessAdapter.this.rootPane.setDefaultButton(CancelableProgessAdapter.this.applicationDefaultButton);
                    }
                    CancelableProgessAdapter.this.applicationDefaultButton = null;
                }
            }
        }, (Object)button));
        return button;
    }

    @Override
    public void animationStarting() {
    }

    @Override
    public void animationStopping() {
        if (this.cancelButton != null) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    CancelableProgessAdapter.this.progressPanel.getComponent().remove(CancelableProgessAdapter.this.cancelButton);
                }
            });
        }
    }

    @Override
    public void paintSubComponents(double maxY) {
        if (this.cancelButton != null) {
            int buttonWidth = 80;
            Rectangle cancelButtonBoundedRectangle = new Rectangle(this.progressPanel.getComponent().getWidth() / 2 - buttonWidth / 2, (int)maxY + 10, 80, 21);
            this.cancelButton.setBounds(cancelButtonBoundedRectangle);
        }
    }

    @Override
    public void rampUpEnded() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CancelableProgessAdapter.this.cancelButton != null) {
                    CancelableProgessAdapter.this.progressPanel.getComponent().add(CancelableProgessAdapter.this.cancelButton);
                }
            }
        });
    }

    public void doCancel() {
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                if (CancelableProgessAdapter.this.cancelButton == null) {
                    CancelableProgessAdapter.this.cancelButton = CancelableProgessAdapter.this.createCancelButton();
                }
                if (CancelableProgessAdapter.this.cancelButton != null) {
                    CancelableProgessAdapter.this.cancelButton.doClick();
                }
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            SwingUtilities.invokeLater(runner);
        }
    }
}

