/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.update;

import com.install4j.api.context.UserCanceledException;
import com.install4j.api.update.ApplicationDisplayMode;
import com.install4j.api.update.UpdateChecker;
import com.install4j.api.update.UpdateDescriptor;
import com.install4j.api.update.UpdateDescriptorEntry;
import com.install4j.api.update.UpdateScheduleRegistry;
import com.macrofocus.resources.properties.PropertiesEvent;
import com.macrofocus.resources.properties.PropertiesListener;
import com.macrofocus.resources.properties.PropertiesModel;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.Action;

public class CheckForUpdateAction
extends AbstractAction {
    private final String updateDescriptorUrl;
    private ApplicationDisplayMode mode = ApplicationDisplayMode.GUI;
    private Action noUpdateAction;
    private Action updateAction;
    private final boolean checkSchedule;

    public CheckForUpdateAction(String updateDescriptorUrl, boolean checkSchedule, final PropertiesModel propertiesModel) {
        this.updateProperties(propertiesModel);
        if (propertiesModel != null) {
            propertiesModel.addPropertiesListener(new PropertiesListener(){

                public void propertiesChanged(PropertiesEvent e) {
                    CheckForUpdateAction.this.updateProperties(propertiesModel);
                }
            });
        }
        this.updateDescriptorUrl = updateDescriptorUrl;
        this.checkSchedule = checkSchedule;
    }

    public void setNoUpdateAction(Action noUpdateAction) {
        this.noUpdateAction = noUpdateAction;
    }

    public void setUpdateAction(Action updateAction) {
        this.updateAction = updateAction;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            boolean update = UpdateScheduleRegistry.checkAndReset();
            if (!this.checkSchedule || update) {
                UpdateDescriptor updateDescriptor = UpdateChecker.getUpdateDescriptor((String)this.updateDescriptorUrl, (ApplicationDisplayMode)this.mode);
                if (updateDescriptor != null) {
                    UpdateDescriptorEntry entry = updateDescriptor.getPossibleUpdateEntry();
                    if (entry != null) {
                        if (this.updateAction != null) {
                            this.updateAction.actionPerformed(e);
                        }
                    } else if (this.noUpdateAction != null) {
                        this.noUpdateAction.actionPerformed(e);
                    }
                } else {
                    System.out.println("UpdateDescriptor is null!");
                }
            }
        }
        catch (UnsatisfiedLinkError e1) {
            e1.printStackTrace();
        }
        catch (NoClassDefFoundError e1) {
            e1.printStackTrace();
        }
        catch (UserCanceledException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        catch (NullPointerException e1) {
            e1.printStackTrace();
        }
    }

    private void updateProperties(PropertiesModel propertiesModel) {
        String name = "Check for Update";
        if (propertiesModel != null && propertiesModel.isAvailable("action.update.label")) {
            name = (String)propertiesModel.getValue("action.update.label");
        }
        this.putValue("Name", name + "...");
    }
}

