/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.util.wizard;

import com.macrofocus.helper.WeakActionListeners;
import com.macrofocus.layoutmanager.HorizontalProportionalLayoutManager;
import com.macrofocus.layoutmanager.PreferredProportionalConstraint;
import com.macrofocus.layoutmanager.RelativeProportionalConstraint;
import com.macrofocus.layoutmanager.VerticalProportionalLayoutManager;
import com.macrofocus.util.file.FileSelectionEvent;
import com.macrofocus.util.file.FileSelectionListener;
import com.macrofocus.util.file.FileSelectionView;
import com.macrofocus.util.file.SimpleSingleFileSelectionModel;
import com.macrofocus.util.file.SingleFileSelectionModel;
import com.macrofocus.util.file.SingleFileSelectionView;
import com.macrofocus.util.wizard.LoadFileSelectionTaskModel;
import com.macrofocus.util.wizard.TaskEvent;
import java.awt.Component;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;

public class DialogLoadFileSelectionTaskModel
extends LoadFileSelectionTaskModel {
    private final WeakActionListeners actionListeners = new WeakActionListeners();
    private JButton nextButton;
    private JButton previousButton;
    private JButton openButton;
    private FileSelectionView fileSelectionView;
    private final SingleFileSelectionModel fileSelectionModel = new SimpleSingleFileSelectionModel();
    private FileFilter defaultFileFilter;
    private List<FileFilter> fileFilters = new ArrayList<FileFilter>();

    public DialogLoadFileSelectionTaskModel(final Component parent) {
        final JTextField textField = new JTextField(40);
        textField.setEditable(false);
        this.openButton = new JButton("Select...");
        this.openButton.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JFileChooser fileChooser = DialogLoadFileSelectionTaskModel.this.getFileSelectionView().getFileChooser();
                fileChooser.rescanCurrentDirectory();
                int returnVal = fileChooser.showOpenDialog(parent);
                if (returnVal == 0) {
                    textField.setText(fileChooser.getSelectedFile().getAbsolutePath());
                    DialogLoadFileSelectionTaskModel.this.fileSelectionModel.setFile(fileChooser.getFileFilter(), fileChooser.getSelectedFile());
                }
            }
        }, (Object)this.openButton));
        JPanel horizontalContainer = new JPanel((LayoutManager)new HorizontalProportionalLayoutManager());
        horizontalContainer.add((Component)new JPanel(), new RelativeProportionalConstraint());
        horizontalContainer.add((Component)new JLabel("Filename:"), new PreferredProportionalConstraint(0, 0, 0, 6));
        horizontalContainer.add((Component)textField, new PreferredProportionalConstraint());
        horizontalContainer.add((Component)this.openButton, new PreferredProportionalConstraint(0, 6, 0, 0));
        horizontalContainer.add((Component)new JPanel(), new RelativeProportionalConstraint());
        JPanel verticalContainer = new JPanel((LayoutManager)new VerticalProportionalLayoutManager());
        verticalContainer.add((Component)new JPanel(), new RelativeProportionalConstraint());
        verticalContainer.add((Component)horizontalContainer, new PreferredProportionalConstraint());
        verticalContainer.add((Component)new JPanel(), new RelativeProportionalConstraint());
        this.setComponent(verticalContainer);
        this.nextButton = new JButton("Next >");
        this.nextButton.setEnabled(this.fileSelectionModel.getFile() != null);
        this.previousButton = new JButton("< Previous");
        this.addButton(this.previousButton);
        this.addButton(this.nextButton);
        this.fileSelectionModel.addSelectionListener(new FileSelectionListener(){

            public void selectionChanged(FileSelectionEvent event) {
                DialogLoadFileSelectionTaskModel.this.nextButton.setEnabled(DialogLoadFileSelectionTaskModel.this.fileSelectionModel.getFile() != null && DialogLoadFileSelectionTaskModel.this.fileSelectionModel.getFile().exists());
            }
        });
        this.nextButton.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DialogLoadFileSelectionTaskModel.this.fileSelectionModel.setFile(DialogLoadFileSelectionTaskModel.this.getFileSelectionView().getFileChooser().getFileFilter(), DialogLoadFileSelectionTaskModel.this.getFileSelectionView().getFileChooser().getSelectedFile());
                DialogLoadFileSelectionTaskModel.this.notifyTaskCompleted(new TaskEvent(this, DialogLoadFileSelectionTaskModel.this.getSelf()));
            }
        }, (Object)this.nextButton));
        this.previousButton.addActionListener(this.actionListeners.create(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                DialogLoadFileSelectionTaskModel.this.notifyTaskAborted(new TaskEvent(this, DialogLoadFileSelectionTaskModel.this.getSelf()));
            }
        }, (Object)this.previousButton));
    }

    @Override
    public void addFileFilter(FileFilter fileFilter) {
        if (this.fileSelectionView != null) {
            this.fileSelectionView.addFileFilter(fileFilter);
        } else {
            this.fileFilters.add(fileFilter);
        }
    }

    @Override
    public void setFileFilter(FileFilter fileFilter) {
        if (this.fileSelectionView != null) {
            this.fileSelectionView.setDefaultFileFilter(fileFilter);
        } else {
            this.defaultFileFilter = fileFilter;
        }
    }

    @Override
    public File getFile() {
        return this.fileSelectionModel.getFile();
    }

    @Override
    public FileFilter getFileFilter() {
        return this.fileSelectionModel.getFileFilter();
    }

    @Override
    public void setDefaultFileFilter(FileFilter defaultFileFilter) {
        if (this.fileSelectionView != null) {
            this.fileSelectionView.setDefaultFileFilter(defaultFileFilter);
        } else {
            this.defaultFileFilter = defaultFileFilter;
        }
    }

    public FileSelectionView getFileSelectionView() {
        if (this.fileSelectionView == null) {
            this.fileSelectionView = new SingleFileSelectionView(this.fileSelectionModel);
            this.fileSelectionView.getFileChooser().setControlButtonsAreShown(true);
            for (FileFilter fileFilter : this.fileFilters) {
                this.fileSelectionView.addFileFilter(fileFilter);
            }
            this.fileSelectionView.setDefaultFileFilter(this.defaultFileFilter);
        }
        return this.fileSelectionView;
    }
}

