/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot.swing;

import com.macrofocus.cartoplot.CartoPlotView;
import com.macrofocus.cartoplot.swing.AbstractCartoPlotView;
import com.macrofocus.cartoplot.swing.tile.SwingTile;
import com.macrofocus.cartoplot.swing.tile.SwingTileFactory;
import com.macrofocus.cartoplot.tile.CartoDBDarkTileFactoryInfo;
import com.macrofocus.cartoplot.tile.CartoDBLightTileFactoryInfo;
import com.macrofocus.cartoplot.tile.OSMTileFactoryInfo;
import com.macrofocus.cartoplot.tile.Tile;
import com.macrofocus.cartoplot.tile.TileFactoryInfo;
import com.macrofocus.cartoplot.tile.TileListener;
import com.macrofocus.common.properties.PropertiesListener;
import com.macrofocus.common.properties.PropertyEvent;
import com.macrofocus.crossplatform.swing.SwingFactory;
import com.macrofocus.geom.Point2D;
import com.macrofocus.geom.Rectangle;
import com.macrofocus.geom.Rectangle2D;
import com.macrofocus.helper.SwingHelper;
import com.macrofocus.igraphics.AbstractIDrawing;
import com.macrofocus.igraphics.CPColor;
import com.macrofocus.igraphics.CPColorFactory;
import com.macrofocus.igraphics.IDrawing;
import com.macrofocus.igraphics.IGraphics;
import com.macrofocus.igraphics.colortheme.ColorTheme;
import com.macrofocus.igraphics.swing.SwingIGraphics;
import com.macrofocus.labeling.EnhancedJLabel;
import com.macrofocus.labeling.EnhancedLabel;
import com.macrofocus.license.LicenseModel;
import com.macrofocus.plot.guide.Guide;
import com.macrofocus.plot.guide.SwingXNumberOneDScreenTransformAxisGuide;
import com.macrofocus.plot.guide.SwingYNumberOneDScreenTransformAxisGuide;
import com.macrofocus.transform.OneDScreenTransform;
import com.macrofocus.transform.ScreenTransformEvent;
import com.macrofocus.transform.ScreenTransformListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.awt.image.LookupOp;
import java.awt.image.RescaleOp;
import java.awt.image.ShortLookupTable;
import java.io.IOException;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.OverlayLayout;

public class SwingCartoPlotView<Row, C, Column>
extends AbstractCartoPlotView<JComponent, Color, Row, Column> {
    private final JComponent nativeComponent;
    private Guide xGuide;
    private Guide yGuide;
    private CPColorFactory<Color> colorFactory = SwingFactory.getInstance();
    private LicenseModel licenseModel;
    private JPanel unregisteredPanel;
    private ComponentAdapter unregisteredPanelListener;
    TileFactoryInfo info = new OSMTileFactoryInfo();
    SwingTileFactory tileFactory;
    private final PropertiesListener<CartoPlotView.PropertyType> propertiesListener = new PropertiesListener<CartoPlotView.PropertyType>(){

        public void propertyChanged(CartoPlotView.PropertyType name, PropertyEvent event) {
            SwingCartoPlotView.this.updateTileFactory();
            SwingCartoPlotView.this.createOverplots();
            SwingCartoPlotView.this.scheduleUpdate();
            if (name == CartoPlotView.PropertyType.ColorTheme) {
                SwingCartoPlotView.this.nativeComponent.updateUI();
                SwingCartoPlotView.this.nativeComponent.repaint();
            }
        }
    };
    private float backgroundAlpha = 0.3f;
    private TileListener tileLoadListener = new TileListener(){

        public void tileLoaded(Tile tile) {
            SwingCartoPlotView.this.nativeComponent.repaint();
        }
    };

    protected void scheduleUpdate() {
        if (this.nativeComponent.isShowing()) {
            this.timer.restart();
            this.nativeComponent.repaint();
        }
    }

    protected void repaint() {
        this.nativeComponent.repaint();
    }

    public SwingCartoPlotView() {
        super(SwingFactory.getInstance());
        this.nativeComponent = new JLayeredPane(){

            @Override
            public void updateUI() {
                SwingCartoPlotView.this.nativeComponent.setBackground(null);
                ColorTheme colorTheme = (ColorTheme)SwingCartoPlotView.this.getColorTheme().getValue();
                if (colorTheme != null) {
                    Color background = SwingCartoPlotView.this.nativeComponent.getBackground();
                    if (background != null) {
                        colorTheme.setBackground(SwingCartoPlotView.this.colorFactory.createRGBAColor(background.getRed(), background.getGreen(), background.getBlue(), background.getAlpha()));
                    }
                    SwingCartoPlotView.this.nativeComponent.setBackground((Color)colorTheme.getBackground().getNativeColor());
                    SwingCartoPlotView.this.nativeComponent.setForeground((Color)colorTheme.getForeground().getNativeColor());
                }
                if (SwingCartoPlotView.this.tileFactory != null) {
                    SwingCartoPlotView.this.tileFactory.clearCache();
                }
            }
        };
        this.nativeComponent.setLayout(new OverlayLayout(this.nativeComponent));
        this.nativeComponent.add((Component)this.canvas.getNativeComponent(), JLayeredPane.MODAL_LAYER);
        this.properties.addPropertiesListener(this.propertiesListener);
        this.nativeComponent.setOpaque(true);
        this.nativeComponent.addHierarchyListener(new HierarchyListener(){

            @Override
            public void hierarchyChanged(HierarchyEvent e) {
                if ((e.getChangeFlags() & 4L) != 0L) {
                    SwingCartoPlotView.this.refresh();
                }
            }
        });
        this.updateTileFactory();
        this.xGuide = new SwingXNumberOneDScreenTransformAxisGuide((OneDScreenTransform)this.screenTransform.getX());
        this.yGuide = new SwingYNumberOneDScreenTransformAxisGuide(Guide.Type.Left, (OneDScreenTransform)this.screenTransform.getY());
        this.screenTransform.addScreenTransformListener(new ScreenTransformListener(){

            public void transformChanged(ScreenTransformEvent event) {
                SwingCartoPlotView.this.timer.restart();
                SwingCartoPlotView.this.nativeComponent.repaint();
            }
        });
        this.nativeComponent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                Dimension d = SwingCartoPlotView.this.nativeComponent.getSize();
                SwingCartoPlotView.this.screenTransform.setScreenSize(d.width, d.height);
            }
        });
        this.nativeComponent.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentShown(ComponentEvent e) {
                SwingCartoPlotView.this.scheduleUpdate();
            }

            @Override
            public void componentResized(ComponentEvent e) {
                SwingCartoPlotView.this.scheduleUpdate();
            }
        });
    }

    private void updateTileFactory() {
        Object info = ((ColorTheme)this.getColorTheme().getValue()).isDark() ? new CartoDBDarkTileFactoryInfo() : new CartoDBLightTileFactoryInfo();
        this.setTileFactory(new SwingTileFactory((TileFactoryInfo)info){

            @Override
            protected BufferedImage createImage(byte[] bimg) throws IOException {
                BufferedImage image = super.createImage(bimg);
                if (SwingCartoPlotView.this.getTileEffect().getValue() == CartoPlotView.TileEffect.BlackWhite) {
                    if (image != null) {
                        BufferedImage copy = new BufferedImage(image.getWidth(), image.getHeight(), 2);
                        copy.getGraphics().drawImage(image, 0, 0, null);
                        ColorConvertOp op = new ColorConvertOp(ColorSpace.getInstance(1003), null);
                        copy = op.filter(copy, copy);
                        if (((ColorTheme)SwingCartoPlotView.this.getColorTheme().getValue()).isDark()) {
                            RescaleOp rescaleOp = new RescaleOp(new float[]{-0.5f, -0.5f, -0.5f, 1.0f}, new float[]{127.0f, 127.0f, 127.0f, 0.0f}, null);
                            copy = rescaleOp.filter(copy, copy);
                        } else {
                            RescaleOp rescaleOp = new RescaleOp(new float[]{0.5f, 0.5f, 0.5f, 1.0f}, new float[]{127.0f, 127.0f, 127.0f, 0.0f}, null);
                            copy = rescaleOp.filter(copy, copy);
                        }
                        if (!((ColorTheme)SwingCartoPlotView.this.getColorTheme().getValue()).isDark()) {
                            // empty if block
                        }
                        return copy;
                    }
                    return null;
                }
                return image;
            }

            private BufferedImage invert(BufferedImage copy) {
                short[] red = new short[256];
                short[] green = new short[256];
                short[] blue = new short[256];
                short[] alpha = new short[256];
                for (int i = 0; i < 256; i = (int)((short)(i + 1))) {
                    red[i] = (short)(255 - i);
                    green[i] = blue[i] = red[i];
                    alpha[i] = i;
                }
                short[][] data = new short[][]{red, green, blue, alpha};
                ShortLookupTable lookupTable = new ShortLookupTable(0, data);
                LookupOp lookupOp = new LookupOp(lookupTable, null);
                copy = lookupOp.filter(copy, copy);
                return copy;
            }
        });
    }

    protected void populateOverplots() {
        this.canvas.addLayer((IDrawing)new SwingMapIDrawing());
        super.populateOverplots();
    }

    public JComponent getNativeComponent() {
        return this.nativeComponent;
    }

    @Override
    public void setLicenseModel(LicenseModel licenseModel) {
        if (this.unregisteredPanel != null) {
            this.nativeComponent.removeComponentListener(this.unregisteredPanelListener);
            this.nativeComponent.remove(this.unregisteredPanel);
            this.unregisteredPanel = null;
            this.unregisteredPanelListener = null;
        }
        if (licenseModel == null || licenseModel.verify() != LicenseModel.State.Valid) {
            EnhancedJLabel unregisteredLabel = new EnhancedJLabel();
            unregisteredLabel.setEffect(EnhancedLabel.Effect.Outline);
            String message = licenseModel == null ? "Unregistered version" : licenseModel.verify().toString();
            unregisteredLabel.setText(message);
            unregisteredLabel.setForeground(new Color(0, 0, 0, 63));
            unregisteredLabel.setBackground(new Color(255, 255, 255));
            unregisteredLabel.setEffectOpacity(0.2f);
            this.unregisteredPanel = new JPanel(){

                @Override
                public void paint(Graphics g) {
                    Graphics2D g2 = (Graphics2D)g;
                    g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                    super.paint(g2);
                }
            };
            this.unregisteredPanel.setOpaque(false);
            this.unregisteredPanel.setLayout(new OverlayLayout(this.unregisteredPanel));
            this.unregisteredPanel.add((Component)unregisteredLabel);
            unregisteredLabel.setFont(unregisteredLabel.getFont().deriveFont(1, 32.0f));
            this.nativeComponent.add((Component)this.unregisteredPanel, JLayeredPane.MODAL_LAYER);
            this.unregisteredPanelListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    SwingHelper.centerBottom((Container)SwingCartoPlotView.this.nativeComponent, (Component)SwingCartoPlotView.this.unregisteredPanel);
                }
            };
            this.nativeComponent.addComponentListener(this.unregisteredPanelListener);
        }
    }

    @Override
    public Guide getXGuide() {
        return this.xGuide;
    }

    @Override
    public Guide getYGuide() {
        return this.yGuide;
    }

    private void refresh() {
        this.canvas.refresh();
    }

    @Override
    public void setTileFactory(SwingTileFactory tileFactory) {
        if (this.tileFactory != tileFactory) {
            if (this.tileFactory != null) {
                this.tileFactory.removeTileListener(this.tileLoadListener);
            }
            this.tileFactory = tileFactory;
            if (this.tileFactory != null) {
                tileFactory.addTileListener(this.tileLoadListener);
                tileFactory.setThreadPoolSize(6);
            }
        }
    }

    private class SwingMapIDrawing
    extends AbstractIDrawing {
        private SwingMapIDrawing() {
        }

        public boolean isActive() {
            return true;
        }

        public void draw(IGraphics g, Point2D point, double width, double height, Rectangle clipBounds) {
            if (SwingCartoPlotView.this.tileFactory != null) {
                Graphics2D context = ((SwingIGraphics)g).getContext();
                int tileSize = SwingCartoPlotView.this.tileFactory.getInfo().getTileSize();
                Rectangle2D worldBounds = SwingCartoPlotView.this.screenTransform.screenToWorld(new Rectangle(0, 0, (int)width, (int)height));
                int zoom = Math.min(SwingCartoPlotView.this.tileFactory.getInfo().getMaximumZoomLevel(), Math.max(SwingCartoPlotView.this.tileFactory.getInfo().getMinimumZoomLevel(), (int)Math.round(Math.log(width * 360.0 / worldBounds.getWidth() / (double)tileSize) / Math.log(2.0))));
                int startX = SwingCartoPlotView.getTileX((double)Math.max(-180.0, worldBounds.getMinX()), (int)zoom) - 1;
                int startY = SwingCartoPlotView.getTileY((double)Math.max(-90.0, com.macrofocus.cartoplot.AbstractCartoPlotView.y2lat((double)worldBounds.getMinY())), (int)zoom) - 1;
                int endX = SwingCartoPlotView.getTileX((double)Math.min(180.0, worldBounds.getMaxX()), (int)zoom) + 1;
                int endY = SwingCartoPlotView.getTileY((double)Math.min(90.0, com.macrofocus.cartoplot.AbstractCartoPlotView.y2lat((double)worldBounds.getMaxY())), (int)zoom) + 1;
                Object antialias = context.getRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING);
                context.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, antialias != null ? antialias : RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                context.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                context.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
                context.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                for (int x = startX; x <= endX; ++x) {
                    for (int y = startY; y <= endY; ++y) {
                        SwingTile tile = SwingCartoPlotView.this.tileFactory.getTile(x, y, zoom, (Boolean)SwingCartoPlotView.this.getWrap().getValue());
                        if (tile == null || !tile.isLoaded()) continue;
                        Rectangle2D bounds = SwingCartoPlotView.this.tile2boundingBox(x, y, zoom);
                        Rectangle p = SwingCartoPlotView.this.screenTransform.worldToScreen(bounds);
                        BufferedImage image = tile.getImage();
                        if (image == null) continue;
                        context.drawImage(image, p.x, p.y, p.x + p.width, p.y + p.height, 0, 0, image.getWidth(), image.getHeight(), null);
                    }
                }
                if (((Boolean)SwingCartoPlotView.this.getDrawTileGrid().getValue()).booleanValue()) {
                    CPColor black = SwingCartoPlotView.this.colorFactory.createRGBAColor(0, 0, 0, 40);
                    CPColor white = SwingCartoPlotView.this.colorFactory.createRGBAColor(255, 255, 255, 40);
                    for (int x = startX; x <= endX; ++x) {
                        for (int y = startY; y <= endY; ++y) {
                            Rectangle2D bounds = SwingCartoPlotView.this.tile2boundingBox(x, y, zoom);
                            Rectangle p = SwingCartoPlotView.this.screenTransform.worldToScreen(bounds);
                            int ox = p.x;
                            int oy = p.y;
                            g.setColor(black);
                            g.drawRectange(ox, oy, p.width, p.height);
                            g.setColor(white);
                            g.drawRectange(ox + 1, oy + 1, p.width, p.height);
                            String text = x + ", " + y + ", " + zoom;
                            context.setColor((Color)black.getNativeColor());
                            context.drawString(text, ox + 10, oy + 20);
                            context.drawString(text, ox + 10 + 2, oy + 20 + 2);
                            context.setColor((Color)white.getNativeColor());
                            context.drawString(text, ox + 10 + 1, oy + 20 + 1);
                        }
                    }
                }
            }
        }
    }
}

