/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.cartoplot.swing.georeferencing;

import com.macrofocus.cartoplot.georeferencing.AbstractGeoReferencingService;
import com.macrofocus.molap.dataframe.DataFrame;
import com.macrofocus.molap.dataframe.swing.ColumnsComboBoxModel;
import com.macrofocus.molap.dataframe.swing.VariableComboBox;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;

public class SwingLatLonGeoReferencingService<R, C>
extends AbstractGeoReferencingService<JComponent, R> {
    private final GeometryFactory geometryFactory = new GeometryFactory();
    private DataFrame dataFrame;
    private C latIndex = null;
    private C lonIndex = null;

    public SwingLatLonGeoReferencingService(DataFrame<R, C, ?> dataFrame) {
        String name;
        this.dataFrame = dataFrame;
        for (Object c : dataFrame.columns()) {
            if (!Number.class.isAssignableFrom(dataFrame.getColumnClass(c))) continue;
            name = dataFrame.getColumnName(c);
            if ("Longitude".equalsIgnoreCase(name) || "Lon".equalsIgnoreCase(name)) {
                this.lonIndex = c;
            }
            if ("Latitude".equalsIgnoreCase(name) || "Lat".equalsIgnoreCase(name)) {
                this.latIndex = c;
            }
            if (this.latIndex == null || this.lonIndex == null) continue;
            break;
        }
        if (this.lonIndex == null || this.latIndex == null) {
            for (Object c : dataFrame.columns()) {
                name = dataFrame.getColumnName(c);
                if (name.toLowerCase().contains("longitude") || name.toLowerCase().startsWith("lon")) {
                    this.lonIndex = c;
                }
                if (name.toLowerCase().contains("latitude") || name.toLowerCase().startsWith("lat")) {
                    this.latIndex = c;
                }
                if (this.latIndex == null || this.lonIndex == null) continue;
                break;
            }
        }
    }

    public boolean isValid() {
        return this.latIndex != null && this.lonIndex != null;
    }

    public JComponent getEditor() {
        VariableComboBox latComboBox = new VariableComboBox((ComboBoxModel)new ColumnsComboBoxModel(this.dataFrame, true, true));
        latComboBox.setSelectedItem(this.getLatIndex());
        latComboBox.getModel().addListDataListener(new ListDataListener(){
            final /* synthetic */ JComboBox val$latComboBox;
            {
                this.val$latComboBox = jComboBox;
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                Object column = this.val$latComboBox.getSelectedItem();
                if (column != null) {
                    SwingLatLonGeoReferencingService.this.setLatIndex(column);
                } else {
                    SwingLatLonGeoReferencingService.this.setLatIndex(null);
                }
            }
        });
        VariableComboBox lonComboBox = new VariableComboBox((ComboBoxModel)new ColumnsComboBoxModel(this.dataFrame, true, true));
        lonComboBox.setSelectedItem(this.getLonIndex());
        lonComboBox.getModel().addListDataListener(new ListDataListener(){
            final /* synthetic */ JComboBox val$lonComboBox;
            {
                this.val$lonComboBox = jComboBox;
            }

            @Override
            public void intervalAdded(ListDataEvent e) {
            }

            @Override
            public void intervalRemoved(ListDataEvent e) {
            }

            @Override
            public void contentsChanged(ListDataEvent e) {
                Object column = this.val$lonComboBox.getSelectedItem();
                if (column != null) {
                    SwingLatLonGeoReferencingService.this.setLonIndex(column);
                } else {
                    SwingLatLonGeoReferencingService.this.setLonIndex(null);
                }
            }
        });
        latComboBox.setSelectedItem(this.getLatIndex());
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(2, 1));
        panel.add((Component)lonComboBox);
        panel.add((Component)latComboBox);
        return panel;
    }

    public boolean isPointGeometry() {
        return true;
    }

    public Geometry getGeometry(R row) {
        if (this.latIndex != null && this.lonIndex != null) {
            Object lonValue = this.dataFrame.getValueAt(row, this.lonIndex);
            Object latValue = this.dataFrame.getValueAt(row, this.latIndex);
            if (lonValue != null && latValue != null && lonValue instanceof Number && latValue instanceof Number) {
                Number lon = (Number)lonValue;
                Number lat = (Number)latValue;
                return this.geometryFactory.createPoint(new Coordinate(lon.doubleValue(), lat.doubleValue()));
            }
        }
        return null;
    }

    public C getLatIndex() {
        return this.latIndex;
    }

    public void setLatIndex(C latIndex) {
        if (this.latIndex != latIndex) {
            C old = this.latIndex;
            this.latIndex = latIndex;
            this.notififyGeoReferencingServiceChanged();
        }
    }

    public C getLonIndex() {
        return this.lonIndex;
    }

    public void setLonIndex(C lonIndex) {
        if (this.lonIndex != lonIndex) {
            C old = this.lonIndex;
            this.lonIndex = lonIndex;
            this.notififyGeoReferencingServiceChanged();
        }
    }

    public String toString() {
        return "Latitude/Longitude";
    }
}

