/*
 * Decompiled with CFR 0.152.
 */
package com.macrofocus.application.high_d.action;

import com.macrofocus.application.high_d.model.HighDModel;
import com.macrofocus.resources.ResourcesModel;
import com.macrofocus.util.swing.FileChooserFactory;
import com.macrofocus.util.swing.action.AbstractMAction;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.ParsingException;

public class ImportSettingsAction
extends AbstractMAction {
    private final FileChooserFactory fileChooserFactory;
    private final Container contentPane;
    private HighDModel model;

    public ImportSettingsAction(Container contentPane, FileChooserFactory fileChooserFactory, ResourcesModel resourcesModel) {
        super("Import Settings", "action.importsettings.label", true, resourcesModel);
        this.fileChooserFactory = fileChooserFactory;
        this.contentPane = contentPane;
        URL url = resourcesModel.getUrl("Import16.gif");
        if (url != null) {
            this.putValue("SmallIcon", new ImageIcon(url));
        }
        this.setModel(null);
    }

    public void actionPerformed(ActionEvent event) {
        File file;
        FileFilter fileFilter = null;
        do {
            JFileChooser fileChooser;
            int value;
            if ((value = (fileChooser = this.fileChooserFactory.getFileChooser()).showOpenDialog(this.contentPane)) != 0) {
                return;
            }
            file = fileChooser.getSelectedFile();
            fileFilter = fileChooser.getFileFilter();
        } while (file == null || !file.exists() || fileFilter == null);
        Builder builder = new Builder(false);
        try {
            BufferedInputStream bis = new BufferedInputStream(new FileInputStream(file));
            Document treemap = builder.build((InputStream)bis);
            Element root = treemap.getRootElement();
            if (root.getLocalName().equals("High-D") || root.getLocalName().equals("ProfilePlot") || root.getLocalName().equals("ll-coords")) {
                this.model.load(root);
            }
        }
        catch (ParsingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void setModel(HighDModel tmm) {
        this.model = tmm;
        this.setEnabled(tmm != null);
    }
}

